/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import matrix.Matrix;

public class Util {
    public static int pickIndexFromRandomVector(Matrix probs, Random r) throws Exception {
        double mass = 1.0;
        int i = 0;
        while (i < probs.w.length) {
            double prob = probs.w[i] / mass;
            if (r.nextDouble() < prob) {
                return i;
            }
            mass -= probs.w[i];
            ++i;
        }
        throw new Exception("no target index selected");
    }

    public static double median(List<Double> vals) {
        Collections.sort(vals);
        int mid = vals.size() / 2;
        if (vals.size() % 2 == 1) {
            return vals.get(mid);
        }
        return (vals.get(mid - 1) + vals.get(mid)) / 2.0;
    }

    public static String timeString(double milliseconds) {
        String result = "";
        int m = (int)milliseconds;
        int hours = 0;
        while (m >= 3600000) {
            m -= 3600000;
            ++hours;
        }
        int minutes = 0;
        while (m >= 60000) {
            m -= 60000;
            ++minutes;
        }
        if (hours > 0) {
            result = String.valueOf(result) + hours + " hours, ";
        }
        int seconds = 0;
        while (m >= 1000) {
            m -= 1000;
            ++seconds;
        }
        result = String.valueOf(result) + minutes + " minutes and ";
        result = String.valueOf(result) + seconds + " seconds.";
        return result;
    }

    public double length(Matrix m) {
        double sum = 0.0;
        double[] dArray = m.w;
        int n = m.w.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d * d;
            ++n2;
        }
        return Math.sqrt(sum);
    }
}

