/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Random;
import model.FeedForwardLayer;
import model.GruLayer;
import model.LinearLayer;
import model.LstmLayer;
import model.NeuralNetwork;
import model.RnnLayer;
import nonlinearities.Nonlinearity;

public class NeuralNetworkHelper {
    public static NeuralNetwork makeLstm(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        NeuralNetwork toReturn = new NeuralNetwork();
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                toReturn.addLayer(new LstmLayer(inputDimension, hiddenDimension, initParamsStdDev, rng));
            } else {
                toReturn.addLayer(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        toReturn.addLayer(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return toReturn;
    }

    public static NeuralNetwork makeLstmWithInputBottleneck(int inputDimension, int bottleneckDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        NeuralNetwork toReturn = new NeuralNetwork();
        toReturn.addLayer(new LinearLayer(inputDimension, bottleneckDimension, initParamsStdDev, rng));
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                toReturn.addLayer(new LstmLayer(bottleneckDimension, hiddenDimension, initParamsStdDev, rng));
            } else {
                toReturn.addLayer(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        toReturn.addLayer(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return toReturn;
    }

    public static NeuralNetwork makeLstmWithMultiLayerInputBottleneck(int inputDimension, int[] bottleneckDimensions, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        NeuralNetwork toReturn = new NeuralNetwork();
        int i = 0;
        while (i < bottleneckDimensions.length) {
            toReturn.addLayer(new LinearLayer(i == 0 ? inputDimension : bottleneckDimensions[i - 1], bottleneckDimensions[i], initParamsStdDev, rng));
            ++i;
        }
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                toReturn.addLayer(new LstmLayer(bottleneckDimensions[bottleneckDimensions.length - 1], hiddenDimension, initParamsStdDev, rng));
            } else {
                toReturn.addLayer(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        toReturn.addLayer(new LinearLayer(hiddenDimension, hiddenDimension / 3, initParamsStdDev, rng));
        toReturn.addLayer(new FeedForwardLayer(hiddenDimension / 3, outputDimension, decoderUnit, initParamsStdDev, rng));
        return toReturn;
    }

    public static NeuralNetwork makeFeedForward(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity hiddenUnit, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        NeuralNetwork toReturn = new NeuralNetwork();
        if (hiddenLayers == 0) {
            toReturn.addLayer(new FeedForwardLayer(inputDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
            return toReturn;
        }
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                toReturn.addLayer(new FeedForwardLayer(inputDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            } else {
                toReturn.addLayer(new FeedForwardLayer(hiddenDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            }
            ++h;
        }
        toReturn.addLayer(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return toReturn;
    }

    public static NeuralNetwork makeGru(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        NeuralNetwork toReturn = new NeuralNetwork();
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                toReturn.addLayer(new GruLayer(inputDimension, hiddenDimension, initParamsStdDev, rng));
            } else {
                toReturn.addLayer(new GruLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        toReturn.addLayer(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return toReturn;
    }

    public static NeuralNetwork makeRnn(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity hiddenUnit, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        NeuralNetwork toReturn = new NeuralNetwork();
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                toReturn.addLayer(new RnnLayer(inputDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            } else {
                toReturn.addLayer(new RnnLayer(hiddenDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            }
            ++h;
        }
        toReturn.addLayer(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return toReturn;
    }
}

