/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import model.NeuralNetwork;
import util.FileChannelInputStream;
import util.FileChannelOutputStream;

public class FileIO {
    public static String readAllText(String path) throws Exception {
        String text = "";
        FileInputStream fis = new FileInputStream(new File(path));
        while (fis.available() > 0) {
            text = String.valueOf(text) + (char)fis.read();
        }
        fis.close();
        return text;
    }

    public static void writeAllText(String path, String text) throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(path));
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            fos.write((byte)c);
            fos.flush();
            ++n2;
        }
        fos.close();
    }

    public static void loadNeuralNetwork(String path, NeuralNetwork network) throws Exception {
        FileIO.loadNeuralNetwork(path, network, false);
    }

    public static void loadNeuralNetwork(String path, NeuralNetwork network, boolean compressed) throws Exception {
        FileInputStream fis = new FileInputStream(path);
        FileChannelInputStream fis2 = new FileChannelInputStream(fis.getChannel());
        if (compressed) {
            InflaterInputStream iin = new InflaterInputStream(fis2, new Inflater(), 0x400000);
            network.loadState(new DataInputStream(iin));
            iin.close();
        } else {
            network.loadState(new DataInputStream(fis2));
            fis2.close();
        }
        fis.close();
    }

    public static void saveNeuralNetwork(String path, NeuralNetwork network) throws Exception {
        FileIO.saveNeuralNetwork(path, network, false);
    }

    public static void saveNeuralNetwork(String path, NeuralNetwork network, boolean compress) throws Exception {
        FileOutputStream fos = new FileOutputStream(path);
        FileChannelOutputStream fos2 = new FileChannelOutputStream(fos.getChannel());
        if (compress) {
            DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)fos2, new Deflater(), 0x400000);
            network.saveState(new DataOutputStream(dout));
            dout.close();
        } else {
            network.saveState(new DataOutputStream(fos2));
            fos2.close();
        }
        fos.close();
    }
}

