/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelInputStream
extends InputStream {
    private ByteBuffer b;
    private FileChannel chann;
    private byte[] buffer;
    private int pos;

    public FileChannelInputStream(FileChannel chann) throws IOException {
        this.chann = chann;
        this.b = ByteBuffer.allocate(0x400000);
        chann.read(this.b);
        this.b.flip();
        this.buffer = new byte[this.b.limit()];
        this.b.get(this.buffer, 0, this.b.limit());
        this.pos = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.buffer.length) {
            if (this.available() <= 0) {
                return -1;
            }
            this.b.clear();
            this.chann.read(this.b);
            this.b.flip();
            if (this.buffer.length != this.b.limit()) {
                this.buffer = new byte[this.b.limit()];
            }
            this.b.get(this.buffer);
            this.pos = 0;
        }
        byte a = this.buffer[this.pos];
        ++this.pos;
        return a & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.b.clear();
        this.chann.close();
    }

    @Override
    public long skip(long s) throws IOException {
        long i = 0L;
        while (i < s) {
            if (this.available() <= 0) {
                return i;
            }
            this.read();
            ++i;
        }
        return s;
    }

    @Override
    public int available() throws IOException {
        if (this.chann.size() - this.chann.position() <= 0L && this.pos < this.buffer.length) {
            return this.buffer.length - this.pos;
        }
        return (int)(this.chann.size() - this.chann.position() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.chann.size() - this.chann.position());
    }
}

