/*
 * Decompiled with CFR 0.152.
 */
package trainer;

import java.util.List;
import matrix.Matrix;
import trainer.Optimizer;

public class RMSProp
extends Optimizer {
    private double decayRate;
    private double smoothEpsilon = 1.0E-8;
    private double gradientClipValue = 5.0;
    private final double regularization = 2.5E-4;

    public RMSProp(double decayRate, double gradientClipValue, double smoothEpsilon) {
        this.decayRate = decayRate;
        this.gradientClipValue = gradientClipValue;
        this.smoothEpsilon = smoothEpsilon;
    }

    public RMSProp(double decayRate, double gradientClipValue) {
        this.decayRate = decayRate;
        this.gradientClipValue = gradientClipValue;
    }

    public RMSProp(double decayRate) {
        this.decayRate = decayRate;
        this.gradientClipValue = 5.0;
    }

    public RMSProp() {
        this.decayRate = 0.99;
        this.gradientClipValue = 5.0;
    }

    @Override
    public void updateParameters(List<Matrix> parameters, double learningRate, int timestep, int batchSize) throws Exception {
        double a = 0.0;
        for (Matrix m : parameters) {
            int i = 0;
            while (i < m.w.length) {
                double mdwi = m.dw[i];
                a = mdwi / (double)batchSize;
                m.stepCache[i] = m.stepCache[i] * this.decayRate + (1.0 - this.decayRate) * (a * a);
                if (mdwi > this.gradientClipValue) {
                    mdwi = this.gradientClipValue;
                }
                if (mdwi < -this.gradientClipValue) {
                    mdwi = -this.gradientClipValue;
                }
                m.w[i] = m.w[i] - learningRate * mdwi / Math.sqrt(m.stepCache[i] + this.smoothEpsilon) - 2.5E-4 * m.w[i];
                m.dw[i] = 0.0;
                ++i;
            }
        }
    }
}

