/*
 * Decompiled with CFR 0.152.
 */
package trainer;

import java.util.List;
import matrix.Matrix;
import trainer.Optimizer;

public class BasicSGD
extends Optimizer {
    private double momentum;

    public BasicSGD() {
        this.momentum = 0.0;
    }

    public BasicSGD(double momentum) {
        this.momentum = momentum;
    }

    @Override
    public void updateParameters(List<Matrix> parameters, double learningRate, int timestep, int batchSize) throws Exception {
        for (Matrix m : parameters) {
            int i = 0;
            while (i < m.w.length) {
                m.stepCache[i] = m.stepCache[i] * this.momentum + m.dw[i] * learningRate;
                int n = i;
                m.w[n] = m.w[n] - m.stepCache[i];
                m.dw[i] = 0.0;
                ++i;
            }
        }
    }
}

