/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.resources;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;
import theGhastModding.weightDisplay.main.WeightMatrix;
import theGhastModding.weightDisplay.renderer.WeightMesh;
import theGhastModding.weightDisplay.resources.BaseModel;
import theGhastModding.weightDisplay.resources.LoaderException;
import theGhastModding.weightDisplay.utils.AdvancedBufferUtils;

public class Loader {
    private List<Integer> vaos = new ArrayList<Integer>();
    private List<Integer> vbos = new ArrayList<Integer>();
    private List<Integer> textures = new ArrayList<Integer>();

    public BaseModel loadToVAO(float[] positions, int[] indices, float[] textureCoords, float[] normals) throws Exception {
        if (positions.length % 3 != 0) {
            throw new LoaderException("Invalid vertex count");
        }
        if (indices.length % 3 != 0) {
            throw new LoaderException("Invalid indices count");
        }
        if (textureCoords.length % 2 != 0) {
            throw new LoaderException("Invalid texture coordinate count");
        }
        if (normals.length % 3 != 0) {
            throw new LoaderException("Invalid texture coordinate count");
        }
        int vaoID = this.createVAO();
        this.bindIndices(indices);
        this.storeDataInAttributeList(0, 3, positions);
        this.storeDataInAttributeList(1, 2, textureCoords);
        this.storeDataInAttributeList(2, 3, normals);
        this.unbindVAO();
        return new BaseModel(vaoID, indices.length);
    }

    public WeightMesh loadChunkMesh(float[] positions, int[] indices, float[] vals, WeightMatrix matrix) throws Exception {
        if (positions.length % 3 != 0) {
            throw new LoaderException("Invalid vertex count");
        }
        if (indices.length % 3 != 0) {
            throw new LoaderException("Invalid indices count");
        }
        int vaoID = this.createVAO();
        this.bindIndices(indices);
        int vbo1 = this.storeDataInAttributeList(0, 3, positions);
        int vbo2 = this.storeDataInAttributeList(1, 1, vals);
        this.unbindVAO();
        return new WeightMesh(new BaseModel(vaoID, indices.length), new int[]{vbo1, vbo2}, false, matrix);
    }

    public void deleteChunkMesh(WeightMesh mesh) throws Exception {
        if (mesh.isEmpty()) {
            return;
        }
        int[] nArray = mesh.getVBOs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int vbo = nArray[n2];
            this.vbos.remove((Object)vbo);
            GL15.glDeleteBuffers(vbo);
            ++n2;
        }
        this.vaos.remove((Object)mesh.getModel().getId());
        GL30.glDeleteVertexArrays(mesh.getModel().getId());
    }

    public BaseModel loadToVAO(float[] positions) throws Exception {
        if (positions.length % 2 != 0) {
            throw new LoaderException("Invalid vertex count");
        }
        int vaoID = this.createVAO();
        this.storeDataInAttributeList(0, 2, positions);
        this.unbindVAO();
        return new BaseModel(vaoID, positions.length / 2);
    }

    public void updateToVbo(int vbo, float[] data, FloatBuffer buffer) throws Exception {
        buffer.clear();
        buffer.put(data);
        buffer.flip();
        GL15.glBindBuffer(34962, vbo);
        GL15.glBufferData(34962, buffer.capacity() * 4, 35040);
        GL15.glBufferSubData(34962, 0L, buffer);
        this.unbindVBO(34962);
    }

    public int loadToVAO(float[] positions, float[] textureCoords) throws Exception {
        if (positions.length % 2 != 0) {
            throw new LoaderException("Invalid vertex count");
        }
        int vaoID = this.createVAO();
        this.storeDataInAttributeList(0, 2, positions);
        this.storeDataInAttributeList(1, 2, textureCoords);
        this.unbindVAO();
        return vaoID;
    }

    public int loadTextureFromBufferedImage(BufferedImage bi) throws Exception {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] pixels_raw = new int[width * height * 4];
        pixels_raw = bi.getRGB(0, 0, width, height, null, 0, width);
        ByteBuffer pixels = BufferUtils.createByteBuffer(width * height * 4);
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int pixel = pixels_raw[i * width + j];
                pixels.put((byte)(pixel >> 16 & 0xFF));
                pixels.put((byte)(pixel >> 8 & 0xFF));
                pixels.put((byte)(pixel & 0xFF));
                pixels.put((byte)(pixel >> 24 & 0xFF));
                ++j;
            }
            ++i;
        }
        pixels.flip();
        int textureID = GL11.glGenTextures();
        this.textures.add(textureID);
        GL11.glBindTexture(3553, textureID);
        GL11.glTexParameterf(3553, 10241, 9728.0f);
        GL11.glTexParameterf(3553, 10240, 9728.0f);
        GL11.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, pixels);
        GL11.glTexParameteri(3553, 10241, 9985);
        GL11.glTexParameteri(3553, 10240, 9985);
        GL30.glGenerateMipmap(3553);
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            GL11.glTexParameterf(3553, 34049, 0.0f);
            float amount = Math.min(4.0f, GL11.glGetFloat(34047));
            GL11.glTexParameterf(3553, 34046, amount);
        } else {
            System.out.println("Anisotropic filtering not supported");
            GL11.glTexParameterf(3553, 34049, -0.5f);
        }
        GL11.glBindTexture(3553, 0);
        return textureID;
    }

    public int loadTextureFromFile(String fileName) throws Exception {
        BufferedImage bi = ImageIO.read(new File(fileName));
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] pixels_raw = new int[width * height * 4];
        pixels_raw = bi.getRGB(0, 0, width, height, null, 0, width);
        ByteBuffer pixels = BufferUtils.createByteBuffer(width * height * 4);
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int pixel = pixels_raw[i * width + j];
                pixels.put((byte)(pixel >> 16 & 0xFF));
                pixels.put((byte)(pixel >> 8 & 0xFF));
                pixels.put((byte)(pixel & 0xFF));
                pixels.put((byte)(pixel >> 24 & 0xFF));
                ++j;
            }
            ++i;
        }
        pixels.flip();
        int textureID = GL11.glGenTextures();
        this.textures.add(textureID);
        GL11.glBindTexture(3553, textureID);
        GL11.glTexParameterf(3553, 10241, 9728.0f);
        GL11.glTexParameterf(3553, 10240, 9728.0f);
        GL11.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, pixels);
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            GL11.glTexParameterf(3553, 34049, 0.0f);
            float amount = Math.min(4.0f, GL11.glGetFloat(34047));
            GL11.glTexParameterf(3553, 34046, amount);
        } else {
            System.out.println("Anisotropic filtering not supported");
            GL11.glTexParameterf(3553, 34049, -0.5f);
        }
        GL11.glBindTexture(3553, 0);
        return textureID;
    }

    public void addInstancedAttribute(int vao, int vbo, int attribute, int dataSize, int instancedDataLength, int offset) {
        GL15.glBindBuffer(34962, vbo);
        GL30.glBindVertexArray(vao);
        GL20.glVertexAttribPointer(attribute, dataSize, 5126, false, instancedDataLength * 4, offset * 4);
        GL33.glVertexAttribDivisor(attribute, 1);
        GL15.glBindBuffer(34962, 0);
        GL30.glBindVertexArray(0);
    }

    private int createVAO() throws Exception {
        int vaoID = GL30.glGenVertexArrays();
        this.vaos.add(vaoID);
        GL30.glBindVertexArray(vaoID);
        return vaoID;
    }

    private int createVBO(int type) throws Exception {
        int vboID = GL15.glGenBuffers();
        this.vbos.add(vboID);
        GL15.glBindBuffer(type, vboID);
        return vboID;
    }

    public int createVBO_S(int floatCount) throws Exception {
        int vboID = this.createVBO(34962);
        GL15.glBufferData(34962, floatCount * 4, 35040);
        this.unbindVBO(34962);
        return vboID;
    }

    private int storeDataInAttributeList(int attributeNumber, int coordinateSize, float[] data) throws Exception {
        int vboID = this.createVBO(34962);
        FloatBuffer buffer = AdvancedBufferUtils.storeDataInBuffer(data);
        GL15.glBufferData(34962, buffer, 35044);
        GL20.glVertexAttribPointer(attributeNumber, coordinateSize, 5126, false, 0, 0L);
        this.unbindVBO(34962);
        return vboID;
    }

    private void unbindVAO() throws Exception {
        GL30.glBindVertexArray(0);
    }

    private void unbindVBO(int type) throws Exception {
        GL15.glBindBuffer(type, 0);
    }

    private void bindIndices(int[] indices) throws Exception {
        this.createVBO(34963);
        IntBuffer buffer = AdvancedBufferUtils.storeDataInBuffer(indices);
        GL15.glBufferData(34963, buffer, 35044);
    }

    public void cleanUp() throws Exception {
        for (Integer i : this.vaos) {
            GL30.glDeleteVertexArrays(i);
        }
        for (Integer i : this.vbos) {
            GL15.glDeleteBuffers(i);
        }
        for (Integer i : this.textures) {
            GL11.glDeleteTextures(i);
        }
    }
}

