/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.resources;

import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import theGhastModding.weightDisplay.main.WeightDisplay;

public class Camera {
    private Vector3f position = new Vector3f(-13.25f, 19.39f, 18.71f);
    private float pitch = 20.500006f;
    private float yaw = 33.800014f;
    private float roll;
    private long window;
    private WeightDisplay wd;
    private static final float MOVE_SPEED = 0.02f;
    private float currentSpeed = 0.0f;
    private float currentStraveSpeed = 0.0f;
    private float currentVerticalSpeed = 0.0f;
    private static final float MOUSE_SENSITIVITY = 0.1f;
    private double lastDx = 0.0;
    private double lastDy = 0.0;

    public Camera(long window, WeightDisplay wd) {
        this.window = window;
        this.wd = wd;
    }

    public void update() {
        this.checkInputs();
        float distance = this.currentSpeed * this.wd.delta / 1000.0f;
        if (this.yaw >= 361.0f) {
            this.yaw += -360.0f;
        }
        if (this.yaw <= -361.0f) {
            this.yaw += 360.0f;
        }
        if (this.pitch >= 361.0f) {
            this.pitch += -360.0f;
        }
        if (this.pitch <= -361.0f) {
            this.pitch += 360.0f;
        }
        float dx = (float)((double)distance * Math.sin(Math.toRadians(-this.getYaw())));
        float dz = (float)((double)distance * Math.cos(Math.toRadians(-this.getYaw())));
        this.move(-dx, this.currentVerticalSpeed * (this.wd.delta / 1000.0f), -dz);
        distance = this.currentStraveSpeed * this.wd.delta / 1000.0f;
        dx = (float)((double)distance * Math.sin(Math.toRadians(-this.getYaw() + 90.0f)));
        dz = (float)((double)distance * Math.cos(Math.toRadians(-this.getYaw() + 90.0f)));
        this.move(dx, 0.0f, dz);
        this.mouse();
    }

    public void move(float dx, float dy, float dz) {
        this.position.x += dx;
        this.position.y += dy;
        this.position.z += dz;
    }

    private void checkInputs() {
        this.currentSpeed = GLFW.glfwGetKey(this.window, 87) == 1 && this.wd.cursorGrabbed ? 0.02f : (GLFW.glfwGetKey(this.window, 83) == 1 && this.wd.cursorGrabbed ? -0.02f : 0.0f);
        this.currentStraveSpeed = GLFW.glfwGetKey(this.window, 68) == 1 && this.wd.cursorGrabbed ? 0.02f : (GLFW.glfwGetKey(this.window, 65) == 1 && this.wd.cursorGrabbed ? -0.02f : 0.0f);
        this.currentVerticalSpeed = GLFW.glfwGetKey(this.window, 32) == 1 && this.wd.cursorGrabbed ? 0.02f : (GLFW.glfwGetKey(this.window, 88) == 1 && this.wd.cursorGrabbed ? -0.02f : 0.0f);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getRoll() {
        return this.roll;
    }

    private void mouse() {
        double[] a = new double[1];
        double[] b = new double[1];
        double dy = 0.0;
        double dx = 0.0;
        GLFW.glfwGetCursorPos(this.window, a, b);
        dx = a[0] - this.lastDx;
        dy = b[0] - this.lastDy;
        this.lastDx = a[0];
        this.lastDy = b[0];
        if (!this.wd.cursorGrabbed) {
            return;
        }
        float pitchChange = -((float)(dy * (double)0.1f));
        this.pitch -= pitchChange;
        float yawChange = (float)(dx * (double)0.1f);
        this.yaw += yawChange;
    }
}

