/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.renderer;

import java.util.ArrayList;
import java.util.List;
import theGhastModding.weightDisplay.main.WeightMatrix;
import theGhastModding.weightDisplay.renderer.WeightMesh;
import theGhastModding.weightDisplay.resources.Loader;

public class WeightsMesher {
    private WeightMatrix matrix;
    private boolean relativeBrightness = false;
    private static final float[] leftFace = new float[]{-0.5f, 0.0f, -0.125f, -0.5f, -1.0f, -0.125f, 0.5f, -1.0f, -0.125f, 0.5f, 0.0f, -0.125f};
    private static final int[] leftIndices;
    private static final float[] rightFace;
    private static final int[] rightIndices;
    private static final float[] frontFace;
    private static final int[] frontIndices;
    private static final float[] backFace;
    private static final int[] backIndices;
    private static final float[] topFace;
    private static final int[] topIndices;
    private static final float[] bottomFace;
    private static final int[] bottomIndices;
    private static final float[][] faceVertices;
    private static final int[][] faceIndices;
    private List<Float> vertices;
    private List<Integer> indices;
    private List<Float> vals;
    private int faceCount;
    private WeightMesh mesh;

    static {
        int[] nArray = new int[6];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 3;
        leftIndices = nArray;
        rightFace = new float[]{-0.5f, 0.0f, 0.125f, -0.5f, -1.0f, 0.125f, 0.5f, -1.0f, 0.125f, 0.5f, 0.0f, 0.125f};
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 3;
        nArray2[4] = 1;
        nArray2[5] = 2;
        rightIndices = nArray2;
        frontFace = new float[]{0.5f, 0.0f, -0.125f, 0.5f, -1.0f, -0.125f, 0.5f, -1.0f, 0.125f, 0.5f, 0.0f, 0.125f};
        int[] nArray3 = new int[6];
        nArray3[0] = 3;
        nArray3[1] = 1;
        nArray3[3] = 2;
        nArray3[4] = 1;
        nArray3[5] = 3;
        frontIndices = nArray3;
        backFace = new float[]{-0.5f, 0.0f, -0.125f, -0.5f, -1.0f, -0.125f, -0.5f, -1.0f, 0.125f, -0.5f, 0.0f, 0.125f};
        int[] nArray4 = new int[6];
        nArray4[1] = 1;
        nArray4[2] = 3;
        nArray4[3] = 3;
        nArray4[4] = 1;
        nArray4[5] = 2;
        backIndices = nArray4;
        topFace = new float[]{-0.5f, 0.0f, 0.125f, -0.5f, 0.0f, -0.125f, 0.5f, 0.0f, -0.125f, 0.5f, 0.0f, 0.125f};
        int[] nArray5 = new int[6];
        nArray5[0] = 3;
        nArray5[1] = 1;
        nArray5[3] = 2;
        nArray5[4] = 1;
        nArray5[5] = 3;
        topIndices = nArray5;
        bottomFace = new float[]{-0.5f, -1.0f, 0.125f, -0.5f, -1.0f, -0.125f, 0.5f, -1.0f, -0.125f, 0.5f, -1.0f, 0.125f};
        int[] nArray6 = new int[6];
        nArray6[1] = 1;
        nArray6[2] = 3;
        nArray6[3] = 3;
        nArray6[4] = 1;
        nArray6[5] = 2;
        bottomIndices = nArray6;
        faceVertices = new float[6][];
        WeightsMesher.faceVertices[0] = leftFace;
        WeightsMesher.faceVertices[1] = rightFace;
        WeightsMesher.faceVertices[2] = frontFace;
        WeightsMesher.faceVertices[3] = backFace;
        WeightsMesher.faceVertices[4] = topFace;
        WeightsMesher.faceVertices[5] = bottomFace;
        faceIndices = new int[6][];
        WeightsMesher.faceIndices[0] = leftIndices;
        WeightsMesher.faceIndices[1] = rightIndices;
        WeightsMesher.faceIndices[2] = frontIndices;
        WeightsMesher.faceIndices[3] = backIndices;
        WeightsMesher.faceIndices[4] = topIndices;
        WeightsMesher.faceIndices[5] = bottomIndices;
    }

    public WeightsMesher(WeightMatrix matrix) {
        this.matrix = matrix;
        this.mesh = null;
    }

    public synchronized WeightMesh getMesh() {
        return this.mesh;
    }

    public int getLastFaceCount() {
        return this.faceCount;
    }

    private float max(float min) {
        float max = 0.0f;
        int i = 0;
        while (i < this.matrix.getWidth()) {
            int j = 0;
            while (j < this.matrix.getHeight()) {
                if ((float)this.matrix.getWeight(i, j) - min > max) {
                    max = (float)this.matrix.getWeight(i, j) - min;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    private float min() {
        float min = 0.0f;
        int i = 0;
        while (i < this.matrix.getWidth()) {
            int j = 0;
            while (j < this.matrix.getHeight()) {
                if ((float)this.matrix.getWeight(i, j) < min) {
                    min = (float)this.matrix.getWeight(i, j);
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public void meshChunk(Loader loader) throws Exception {
        this.vertices = new ArrayList<Float>();
        this.indices = new ArrayList<Integer>();
        this.vals = new ArrayList<Float>();
        if (this.mesh != null) {
            loader.deleteChunkMesh(this.mesh);
        }
        float mul = 0.5f;
        float add = 1.0f;
        if (this.relativeBrightness) {
            float min = this.min();
            float max = this.max(min);
            mul = 1.0f / max;
            add = -min;
        }
        int i = 0;
        while (i < this.matrix.getWidth()) {
            this.tryAddFace(5, this.matrix.getWeight(i, 0), i, 0, 0, mul, add);
            this.tryAddFace(0, this.matrix.getWeight(i, 0), i, 0, 0, mul, add);
            this.tryAddFace(1, this.matrix.getWeight(i, 0), i, 0, 0, mul, add);
            int y = this.matrix.getHeight() - 1;
            this.tryAddFace(4, this.matrix.getWeight(i, y), i, y, 0, mul, add);
            this.tryAddFace(0, this.matrix.getWeight(i, y), i, y, 0, mul, add);
            this.tryAddFace(1, this.matrix.getWeight(i, y), i, y, 0, mul, add);
            if (i == 0) {
                this.tryAddFace(3, this.matrix.getWeight(i, 0), i, 0, 0, mul, add);
                this.tryAddFace(3, this.matrix.getWeight(i, y), i, y, 0, mul, add);
            }
            if (i == this.matrix.getWidth() - 1) {
                this.tryAddFace(2, this.matrix.getWeight(i, 0), i, 0, 0, mul, add);
                this.tryAddFace(2, this.matrix.getWeight(i, y), i, y, 0, mul, add);
            }
            ++i;
        }
        i = 1;
        while (i < this.matrix.getHeight() - 1) {
            this.tryAddFace(0, this.matrix.getWeight(0, i), 0, i, 0, mul, add);
            this.tryAddFace(1, this.matrix.getWeight(0, i), 0, i, 0, mul, add);
            this.tryAddFace(3, this.matrix.getWeight(0, i), 0, i, 0, mul, add);
            int x = this.matrix.getWidth() - 1;
            this.tryAddFace(0, this.matrix.getWeight(x, i), x, i, 0, mul, add);
            this.tryAddFace(1, this.matrix.getWeight(x, i), x, i, 0, mul, add);
            this.tryAddFace(2, this.matrix.getWeight(x, i), x, i, 0, mul, add);
            ++i;
        }
        i = 1;
        while (i < this.matrix.getWidth() - 1) {
            int j = 1;
            while (j < this.matrix.getHeight() - 1) {
                this.tryAddFace(0, this.matrix.getWeight(i, j), i, j, 0, mul, add);
                this.tryAddFace(1, this.matrix.getWeight(i, j), i, j, 0, mul, add);
                ++j;
            }
            ++i;
        }
        if (this.vertices.isEmpty()) {
            this.mesh = new WeightMesh(null, null, true, null);
            return;
        }
        float[] verticesArray = new float[this.vertices.size()];
        int i2 = 0;
        while (i2 < this.vertices.size()) {
            verticesArray[i2] = this.vertices.get(i2).floatValue();
            ++i2;
        }
        this.vertices.clear();
        int[] indicesArray = new int[this.indices.size()];
        int i3 = 0;
        while (i3 < this.indices.size()) {
            indicesArray[i3] = this.indices.get(i3);
            ++i3;
        }
        this.indices.clear();
        float[] valsArray = new float[this.vals.size()];
        int i4 = 0;
        while (i4 < this.vals.size()) {
            valsArray[i4] = this.vals.get(i4).floatValue();
            ++i4;
        }
        this.vals.clear();
        this.mesh = loader.loadChunkMesh(verticesArray, indicesArray, valsArray, this.matrix);
    }

    private void tryAddFace(int face, double w, int x, int y, int z, float mul, float add) {
        int origSize = this.vertices.size() / 3;
        int i = 0;
        while (i < faceVertices[face].length) {
            int offset = 0;
            if (i % 3 == 0) {
                offset = x;
            }
            if (i % 3 == 1) {
                offset = y;
            }
            if (i % 3 == 2) {
                offset = z;
            }
            float offsetCoord = faceVertices[face][i] + (float)offset;
            this.vertices.add(Float.valueOf(offsetCoord));
            ++i;
        }
        i = 0;
        while (i < faceIndices[face].length) {
            this.indices.add(faceIndices[face][i] + origSize);
            ++i;
        }
        float val = (float)w;
        val = (val + add) * mul;
        if (face == 4) {
            val = 0.8f;
        }
        if (face == 2 || face == 3) {
            val = 0.5f;
        }
        if (face == 5) {
            val = 1.0f;
        }
        this.vals.add(Float.valueOf(val));
        this.vals.add(Float.valueOf(val));
        this.vals.add(Float.valueOf(val));
        this.vals.add(Float.valueOf(val));
        ++this.faceCount;
    }

    public void setUseRelativeBrightness(boolean a) {
        this.relativeBrightness = a;
    }

    public boolean isUsingRelativeBrightness() {
        return this.relativeBrightness;
    }
}

