/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.main;

import org.joml.Vector3f;

public class WeightMatrix {
    public double[] weights;
    public static final int BLOCK_FACE_LEFT = 0;
    public static final int BLOCK_FACE_RIGHT = 1;
    public static final int BLOCK_FACE_FRONT = 2;
    public static final int BLOCK_FACE_BACK = 3;
    public static final int BLOCK_FACE_TOP = 4;
    public static final int BLOCK_FACE_BOTTOM = 5;
    private Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
    private float scale;
    private int width;
    private int height;
    private float distance = 0.0f;
    private float originalScale;
    private boolean inAnimation = false;
    private int animationType = 0;
    private int animationStep;
    private int acount;
    public static final int ANIMATION_DISAPEAR = 0;
    public static final int ANIMATION_APPEAR = 1;
    public static final int ANIMATION_MOVE_RIGHT = 2;
    public static final int ANIMATION_MOVE_LEFT = 3;
    private static final int animationLength = 30;

    public WeightMatrix(int width, int height, float zPos, float distance) {
        this.width = width;
        this.height = height;
        this.distance = distance;
        this.weights = new double[width * height];
        int i = 0;
        while (i < width * height) {
            this.weights[i] = 0.0;
            ++i;
        }
        this.scale = 16.0f / (float)width;
        this.pos.set(this.pos.x(), this.pos.y(), zPos);
        this.originalScale = this.scale;
    }

    public void updateAnimation() {
        if (!this.inAnimation) {
            return;
        }
        if (this.animationType == 0) {
            this.pos.set(this.pos.x(), this.pos.y(), this.pos.z() + this.distance * (float)this.acount * 2.0f / 30.0f);
            this.scale -= this.originalScale / 30.0f;
            if (this.animationStep == 29) {
                this.scale = 0.0f;
            }
        } else if (this.animationType == 1) {
            this.pos.set(this.pos.x(), this.pos.y(), this.pos.z() - this.distance * (float)this.acount * 2.0f / 30.0f);
            this.scale += this.originalScale / 30.0f;
            if (this.animationStep == 29) {
                this.scale = this.originalScale;
            }
        } else if (this.animationType == 2) {
            this.pos.set(this.pos.x(), this.pos.y(), this.pos.z() + this.distance * (float)this.acount / 30.0f);
        } else if (this.animationType == 3) {
            this.pos.set(this.pos.x(), this.pos.y(), this.pos.z() - this.distance * (float)this.acount / 30.0f);
        } else {
            this.inAnimation = false;
        }
        ++this.animationStep;
        if (this.animationStep == 30) {
            this.inAnimation = false;
        }
    }

    public void setAnimation(int animationType, int acount) {
        if (this.inAnimation) {
            return;
        }
        this.animationType = animationType;
        this.inAnimation = true;
        this.animationStep = 0;
        this.acount = acount;
    }

    public boolean isInAnimation() {
        return this.inAnimation;
    }

    public double getWeight(int x, int y) {
        return this.weights[this.indx(x, y)];
    }

    public int indx(int x, int y) {
        return y * this.width + x;
    }

    public void setWeightVal(int x, int y, double val) {
        this.weights[this.indx((int)x, (int)y)] = val;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public float getScale() {
        return this.scale;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

