/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTMultiviewDrawBuffers {
    public static final int GL_COLOR_ATTACHMENT_EXT = 37104;
    public static final int GL_MULTIVIEW_EXT = 37105;
    public static final int GL_DRAW_BUFFER_EXT = 3073;
    public static final int GL_READ_BUFFER_EXT = 3074;
    public static final int GL_MAX_MULTIVIEW_BUFFERS_EXT = 37106;

    protected EXTMultiviewDrawBuffers() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glReadBufferIndexedEXT, caps.glDrawBuffersIndexedEXT, caps.glGetIntegeri_vEXT);
    }

    public static native void glReadBufferIndexedEXT(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1);

    public static native void nglDrawBuffersIndexedEXT(int var0, long var1, long var3);

    public static void glDrawBuffersIndexedEXT(@NativeType(value="const GLenum *") IntBuffer location, @NativeType(value="const GLint *") IntBuffer indices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, location.remaining());
        }
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(location.remaining(), MemoryUtil.memAddress(location), MemoryUtil.memAddress(indices));
    }

    public static native void nglGetIntegeri_vEXT(int var0, int var1, long var2);

    public static void glGetIntegeri_vEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLint *") IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetIntegeriEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress(data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDrawBuffersIndexedEXT(@NativeType(value="const GLenum *") int[] location, @NativeType(value="const GLint *") int[] indices) {
        long __functionAddress = GLES.getICD().glDrawBuffersIndexedEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indices, location.length);
        }
        JNI.callPPV(__functionAddress, location.length, location, indices);
    }

    public static void glGetIntegeri_vEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLint *") int[] data) {
        long __functionAddress = GLES.getICD().glGetIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    static {
        GLES.initialize();
    }
}

