/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class GL40 {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_GEOMETRY_SHADER_INVOCATIONS = 34943;
    public static final int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 36442;
    public static final int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 36443;
    public static final int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 36444;
    public static final int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 36445;
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;
    public static final int GL_SAMPLE_SHADING = 35894;
    public static final int GL_MIN_SAMPLE_SHADING_VALUE = 35895;
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;
    public static final int GL_PATCHES = 14;
    public static final int GL_PATCH_VERTICES = 36466;
    public static final int GL_PATCH_DEFAULT_INNER_LEVEL = 36467;
    public static final int GL_PATCH_DEFAULT_OUTER_LEVEL = 36468;
    public static final int GL_TESS_CONTROL_OUTPUT_VERTICES = 36469;
    public static final int GL_TESS_GEN_MODE = 36470;
    public static final int GL_TESS_GEN_SPACING = 36471;
    public static final int GL_TESS_GEN_VERTEX_ORDER = 36472;
    public static final int GL_TESS_GEN_POINT_MODE = 36473;
    public static final int GL_ISOLINES = 36474;
    public static final int GL_FRACTIONAL_ODD = 36475;
    public static final int GL_FRACTIONAL_EVEN = 36476;
    public static final int GL_MAX_PATCH_VERTICES = 36477;
    public static final int GL_MAX_TESS_GEN_LEVEL = 36478;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 36479;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 36480;
    public static final int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 36481;
    public static final int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 36482;
    public static final int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 36483;
    public static final int GL_MAX_TESS_PATCH_COMPONENTS = 36484;
    public static final int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 36485;
    public static final int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 36486;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 36489;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 36490;
    public static final int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 34924;
    public static final int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 34925;
    public static final int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 36382;
    public static final int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 36383;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 34032;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 34033;
    public static final int GL_TESS_EVALUATION_SHADER = 36487;
    public static final int GL_TESS_CONTROL_SHADER = 36488;
    public static final int GL_TEXTURE_CUBE_MAP_ARRAY = 36873;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 36874;
    public static final int GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 36875;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY = 36876;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 36877;
    public static final int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 36878;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 36879;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 36447;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 36464;
    public static final int GL_MAX_VERTEX_STREAMS = 36465;

    protected GL40() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBlendEquationi, caps.glBlendEquationSeparatei, caps.glBlendFunci, caps.glBlendFuncSeparatei, caps.glDrawArraysIndirect, caps.glDrawElementsIndirect, caps.glUniform1d, caps.glUniform2d, caps.glUniform3d, caps.glUniform4d, caps.glUniform1dv, caps.glUniform2dv, caps.glUniform3dv, caps.glUniform4dv, caps.glUniformMatrix2dv, caps.glUniformMatrix3dv, caps.glUniformMatrix4dv, caps.glUniformMatrix2x3dv, caps.glUniformMatrix2x4dv, caps.glUniformMatrix3x2dv, caps.glUniformMatrix3x4dv, caps.glUniformMatrix4x2dv, caps.glUniformMatrix4x3dv, caps.glGetUniformdv, caps.glMinSampleShading, caps.glGetSubroutineUniformLocation, caps.glGetSubroutineIndex, caps.glGetActiveSubroutineUniformiv, caps.glGetActiveSubroutineUniformName, caps.glGetActiveSubroutineName, caps.glUniformSubroutinesuiv, caps.glGetUniformSubroutineuiv, caps.glGetProgramStageiv, caps.glPatchParameteri, caps.glPatchParameterfv, caps.glBindTransformFeedback, caps.glDeleteTransformFeedbacks, caps.glGenTransformFeedbacks, caps.glIsTransformFeedback, caps.glPauseTransformFeedback, caps.glResumeTransformFeedback, caps.glDrawTransformFeedback, caps.glDrawTransformFeedbackStream, caps.glBeginQueryIndexed, caps.glEndQueryIndexed, caps.glGetQueryIndexediv);
    }

    public static native void glBlendEquationi(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1);

    public static native void glBlendEquationSeparatei(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2);

    public static native void glBlendFunci(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2);

    public static native void glBlendFuncSeparatei(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2, @NativeType(value="GLenum") int var3, @NativeType(value="GLenum") int var4);

    public static native void nglDrawArraysIndirect(int var0, long var1);

    public static void glDrawArraysIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 16);
        }
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") long indirect) {
        GL40.nglDrawArraysIndirect(mode, indirect);
    }

    public static void glDrawArraysIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 4);
        }
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static native void nglDrawElementsIndirect(int var0, int var1, long var2);

    public static void glDrawElementsIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="const void *") ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 20);
        }
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="const void *") long indirect) {
        GL40.nglDrawElementsIndirect(mode, type, indirect);
    }

    public static void glDrawElementsIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="const void *") IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, 5);
        }
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static native void glUniform1d(@NativeType(value="GLint") int var0, @NativeType(value="GLdouble") double var1);

    public static native void glUniform2d(@NativeType(value="GLint") int var0, @NativeType(value="GLdouble") double var1, @NativeType(value="GLdouble") double var3);

    public static native void glUniform3d(@NativeType(value="GLint") int var0, @NativeType(value="GLdouble") double var1, @NativeType(value="GLdouble") double var3, @NativeType(value="GLdouble") double var5);

    public static native void glUniform4d(@NativeType(value="GLint") int var0, @NativeType(value="GLdouble") double var1, @NativeType(value="GLdouble") double var3, @NativeType(value="GLdouble") double var5, @NativeType(value="GLdouble") double var7);

    public static native void nglUniform1dv(int var0, int var1, long var2);

    public static void glUniform1dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniform1dv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglUniform2dv(int var0, int var1, long var2);

    public static void glUniform2dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniform2dv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform3dv(int var0, int var1, long var2);

    public static void glUniform3dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniform3dv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform4dv(int var0, int var1, long var2);

    public static void glUniform4dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniform4dv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix2dv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix3dv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix4dv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2x3dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2x3dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix2x3dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2x4dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2x4dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix2x4dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3x2dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3x2dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix3x2dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3x4dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3x4dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix3x4dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4x2dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4x2dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix4x2dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4x3dv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4x3dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        GL40.nglUniformMatrix4x3dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglGetUniformdv(int var0, int var1, long var2);

    public static void glGetUniformdv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLdouble *") DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL40.nglGetUniformdv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static double glGetUniformd(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            GL40.nglGetUniformdv(program, location, MemoryUtil.memAddress(params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glMinSampleShading(@NativeType(value="GLfloat") float var0);

    public static native int nglGetSubroutineUniformLocation(int var0, int var1, long var2);

    @NativeType(value="GLint")
    public static int glGetSubroutineUniformLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL40.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLint")
    public static int glGetSubroutineUniformLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL40.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetSubroutineIndex(int var0, int var1, long var2);

    @NativeType(value="GLuint")
    public static int glGetSubroutineIndex(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL40.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLuint")
    public static int glGetSubroutineIndex(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GL40.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveSubroutineUniformiv(int var0, int var1, int var2, int var3, long var4);

    public static void glGetActiveSubroutineUniformiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)values, 1);
        }
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetActiveSubroutineUniformi(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveSubroutineUniformName(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei") int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index) {
        return GL40.glGetActiveSubroutineUniformName(program, shadertype, index, GL40.glGetActiveSubroutineUniformi(program, shadertype, index, 35385));
    }

    public static native void nglGetActiveSubroutineName(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        GL40.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei") int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index) {
        return GL40.glGetActiveSubroutineName(program, shadertype, index, GL40.glGetProgramStagei(program, shadertype, 36424));
    }

    public static native void nglUniformSubroutinesuiv(int var0, int var1, long var2);

    public static void glUniformSubroutinesuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="const GLuint *") IntBuffer indices) {
        GL40.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.memAddress(indices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glUniformSubroutinesui(@NativeType(value="GLenum") int shadertype, @NativeType(value="const GLuint *") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer indices = stack.ints(index);
            GL40.nglUniformSubroutinesuiv(shadertype, 1, MemoryUtil.memAddress(indices));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformSubroutineuiv(int var0, int var1, long var2);

    public static void glGetUniformSubroutineuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLint") int location, @NativeType(value="GLuint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetUniformSubroutineui(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLint") int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramStageiv(int var0, int var1, int var2, long var3);

    public static void glGetProgramStageiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)values, 1);
        }
        GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetProgramStagei(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glPatchParameteri(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1);

    public static native void nglPatchParameterfv(int var0, long var1);

    public static void glPatchParameterfv(@NativeType(value="GLenum") int pname, @NativeType(value="const GLfloat *") FloatBuffer values) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)values, GL11.glGetInteger(36466));
        }
        GL40.nglPatchParameterfv(pname, MemoryUtil.memAddress(values));
    }

    public static native void glBindTransformFeedback(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void nglDeleteTransformFeedbacks(int var0, long var1);

    public static void glDeleteTransformFeedbacks(@NativeType(value="const GLuint *") IntBuffer ids) {
        GL40.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTransformFeedbacks(@NativeType(value="const GLuint *") int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GL40.nglDeleteTransformFeedbacks(1, MemoryUtil.memAddress(ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenTransformFeedbacks(int var0, long var1);

    public static void glGenTransformFeedbacks(@NativeType(value="GLuint *") IntBuffer ids) {
        GL40.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenTransformFeedbacks() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GL40.nglGenTransformFeedbacks(1, MemoryUtil.memAddress(ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLboolean")
    public static native boolean glIsTransformFeedback(@NativeType(value="GLuint") int var0);

    public static native void glPauseTransformFeedback();

    public static native void glResumeTransformFeedback();

    public static native void glDrawTransformFeedback(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glDrawTransformFeedbackStream(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1, @NativeType(value="GLuint") int var2);

    public static native void glBeginQueryIndexed(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1, @NativeType(value="GLuint") int var2);

    public static native void glEndQueryIndexed(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void nglGetQueryIndexediv(int var0, int var1, int var2, long var3);

    public static void glGetQueryIndexediv(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetQueryIndexedi(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDrawArraysIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") int[] indirect) {
        long __functionAddress = GL.getICD().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indirect, 4);
        }
        JNI.callPV(__functionAddress, mode, indirect);
    }

    public static void glDrawElementsIndirect(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="const void *") int[] indirect) {
        long __functionAddress = GL.getICD().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indirect, 5);
        }
        JNI.callPV(__functionAddress, mode, type, indirect);
    }

    public static void glUniform1dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniform1dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniform2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniform3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4dv(@NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniform4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniformMatrix2dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, transpose, value);
    }

    public static void glUniformMatrix3dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 9, transpose, value);
    }

    public static void glUniformMatrix4dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 4, transpose, value);
    }

    public static void glUniformMatrix2x3dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 6, transpose, value);
    }

    public static void glUniformMatrix2x4dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 3, transpose, value);
    }

    public static void glUniformMatrix3x2dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 6, transpose, value);
    }

    public static void glUniformMatrix3x4dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 12, transpose, value);
    }

    public static void glUniformMatrix4x2dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 3, transpose, value);
    }

    public static void glUniformMatrix4x3dv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 12, transpose, value);
    }

    public static void glGetUniformdv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLdouble *") double[] params) {
        long __functionAddress = GL.getICD().glGetUniformdv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetActiveSubroutineUniformiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] values) {
        long __functionAddress = GL.getICD().glGetActiveSubroutineUniformiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(values, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveSubroutineUniformName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveSubroutineName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glUniformSubroutinesuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="const GLuint *") int[] indices) {
        long __functionAddress = GL.getICD().glUniformSubroutinesuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, indices.length, indices);
    }

    public static void glGetUniformSubroutineuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLint") int location, @NativeType(value="GLuint *") int[] params) {
        long __functionAddress = GL.getICD().glGetUniformSubroutineuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetProgramStageiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] values) {
        long __functionAddress = GL.getICD().glGetProgramStageiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(values, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, pname, values);
    }

    public static void glPatchParameterfv(@NativeType(value="GLenum") int pname, @NativeType(value="const GLfloat *") float[] values) {
        long __functionAddress = GL.getICD().glPatchParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (Checks.DEBUG) {
                Checks.check(values, GL11.glGetInteger(36466));
            }
        }
        JNI.callPV(__functionAddress, pname, values);
    }

    public static void glDeleteTransformFeedbacks(@NativeType(value="const GLuint *") int[] ids) {
        long __functionAddress = GL.getICD().glDeleteTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGenTransformFeedbacks(@NativeType(value="GLuint *") int[] ids) {
        long __functionAddress = GL.getICD().glGenTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGetQueryIndexediv(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GL.getICD().glGetQueryIndexediv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, target, index, pname, params);
    }

    static {
        GL.initialize();
    }
}

