/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import org.lwjgl.nanovg.LibNanoVG;
import org.lwjgl.nanovg.NVGLUFramebuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public class NanoVGGL3 {
    public static final int NVG_ANTIALIAS = 1;
    public static final int NVG_STENCIL_STROKES = 2;
    public static final int NVG_DEBUG = 4;
    public static final int NVG_IMAGE_NODELETE = 65536;

    protected NanoVGGL3() {
        throw new UnsupportedOperationException();
    }

    public static native int nnvglCreateImageFromHandleGL3(long var0, int var2, int var3, int var4, int var5);

    public static int nvglCreateImageFromHandle(long ctx, int textureId, int w, int h, int flags) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return NanoVGGL3.nnvglCreateImageFromHandleGL3(ctx, textureId, w, h, flags);
    }

    public static native int nnvglImageHandleGL3(long var0, int var2);

    public static int nvglImageHandle(long ctx, int image) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return NanoVGGL3.nnvglImageHandleGL3(ctx, image);
    }

    public static native long nnvgCreateGL3(int var0);

    public static long nvgCreate(int flags) {
        return NanoVGGL3.nnvgCreateGL3(flags);
    }

    public static native void nnvgDeleteGL3(long var0);

    public static void nvgDelete(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVGGL3.nnvgDeleteGL3(ctx);
    }

    public static native long nnvgluCreateFramebufferGL3(long var0, int var2, int var3, int var4);

    public static NVGLUFramebuffer nvgluCreateFramebuffer(long ctx, int w, int h, int imageFlags) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        long __result = NanoVGGL3.nnvgluCreateFramebufferGL3(ctx, w, h, imageFlags);
        return NVGLUFramebuffer.create(__result);
    }

    public static native void nnvgluBindFramebufferGL3(long var0, long var2);

    public static void nvgluBindFramebuffer(long ctx, NVGLUFramebuffer fb) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVGGL3.nnvgluBindFramebufferGL3(ctx, MemoryUtil.memAddressSafe(fb));
    }

    public static native void nnvgluDeleteFramebufferGL3(long var0, long var2);

    public static void nvgluDeleteFramebuffer(long ctx, NVGLUFramebuffer fb) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVGGL3.nnvgluDeleteFramebufferGL3(ctx, fb.address());
    }

    static {
        LibNanoVG.initialize();
    }
}

