/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.nanovg.LibNanoVG;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGGlyphPosition;
import org.lwjgl.nanovg.NVGPaint;
import org.lwjgl.nanovg.NVGTextRow;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NanoVG {
    public static final float NVG_PI = (float)Math.PI;
    public static final int NVG_CCW = 1;
    public static final int NVG_CW = 2;
    public static final int NVG_SOLID = 1;
    public static final int NVG_HOLE = 2;
    public static final int NVG_BUTT = 0;
    public static final int NVG_ROUND = 1;
    public static final int NVG_SQUARE = 2;
    public static final int NVG_BEVEL = 3;
    public static final int NVG_MITER = 4;
    public static final int NVG_ALIGN_LEFT = 1;
    public static final int NVG_ALIGN_CENTER = 2;
    public static final int NVG_ALIGN_RIGHT = 4;
    public static final int NVG_ALIGN_TOP = 8;
    public static final int NVG_ALIGN_MIDDLE = 16;
    public static final int NVG_ALIGN_BOTTOM = 32;
    public static final int NVG_ALIGN_BASELINE = 64;
    public static final int NVG_ZERO = 1;
    public static final int NVG_ONE = 2;
    public static final int NVG_SRC_COLOR = 4;
    public static final int NVG_ONE_MINUS_SRC_COLOR = 8;
    public static final int NVG_DST_COLOR = 16;
    public static final int NVG_ONE_MINUS_DST_COLOR = 32;
    public static final int NVG_SRC_ALPHA = 64;
    public static final int NVG_ONE_MINUS_SRC_ALPHA = 128;
    public static final int NVG_DST_ALPHA = 256;
    public static final int NVG_ONE_MINUS_DST_ALPHA = 512;
    public static final int NVG_SRC_ALPHA_SATURATE = 1024;
    public static final int NVG_SOURCE_OVER = 0;
    public static final int NVG_SOURCE_IN = 1;
    public static final int NVG_SOURCE_OUT = 2;
    public static final int NVG_ATOP = 3;
    public static final int NVG_DESTINATION_OVER = 4;
    public static final int NVG_DESTINATION_IN = 5;
    public static final int NVG_DESTINATION_OUT = 6;
    public static final int NVG_DESTINATION_ATOP = 7;
    public static final int NVG_LIGHTER = 8;
    public static final int NVG_COPY = 9;
    public static final int NVG_XOR = 10;
    public static final int NVG_IMAGE_GENERATE_MIPMAPS = 1;
    public static final int NVG_IMAGE_REPEATX = 2;
    public static final int NVG_IMAGE_REPEATY = 4;
    public static final int NVG_IMAGE_FLIPY = 8;
    public static final int NVG_IMAGE_PREMULTIPLIED = 16;
    public static final int NVG_IMAGE_NEAREST = 32;

    protected NanoVG() {
        throw new UnsupportedOperationException();
    }

    public static native void nnvgBeginFrame(long var0, int var2, int var3, float var4);

    public static void nvgBeginFrame(long ctx, int windowWidth, int windowHeight, float devicePixelRatio) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgBeginFrame(ctx, windowWidth, windowHeight, devicePixelRatio);
    }

    public static native void nnvgCancelFrame(long var0);

    public static void nvgCancelFrame(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgCancelFrame(ctx);
    }

    public static native void nnvgEndFrame(long var0);

    public static void nvgEndFrame(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgEndFrame(ctx);
    }

    public static native void nnvgGlobalCompositeOperation(long var0, int var2);

    public static void nvgGlobalCompositeOperation(long ctx, int op) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgGlobalCompositeOperation(ctx, op);
    }

    public static native void nnvgGlobalCompositeBlendFunc(long var0, int var2, int var3);

    public static void nvgGlobalCompositeBlendFunc(long ctx, int sfactor, int dfactor) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgGlobalCompositeBlendFunc(ctx, sfactor, dfactor);
    }

    public static native void nnvgGlobalCompositeBlendFuncSeparate(long var0, int var2, int var3, int var4, int var5);

    public static void nvgGlobalCompositeBlendFuncSeparate(long ctx, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgGlobalCompositeBlendFuncSeparate(ctx, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public static native void nnvgRGB(byte var0, byte var1, byte var2, long var3);

    public static NVGColor nvgRGB(byte r, byte g, byte b, NVGColor __result) {
        NanoVG.nnvgRGB(r, g, b, __result.address());
        return __result;
    }

    public static native void nnvgRGBf(float var0, float var1, float var2, long var3);

    public static NVGColor nvgRGBf(float r, float g, float b, NVGColor __result) {
        NanoVG.nnvgRGBf(r, g, b, __result.address());
        return __result;
    }

    public static native void nnvgRGBA(byte var0, byte var1, byte var2, byte var3, long var4);

    public static NVGColor nvgRGBA(byte r, byte g, byte b, byte a, NVGColor __result) {
        NanoVG.nnvgRGBA(r, g, b, a, __result.address());
        return __result;
    }

    public static native void nnvgRGBAf(float var0, float var1, float var2, float var3, long var4);

    public static NVGColor nvgRGBAf(float r, float g, float b, float a, NVGColor __result) {
        NanoVG.nnvgRGBAf(r, g, b, a, __result.address());
        return __result;
    }

    public static native void nnvgLerpRGBA(long var0, long var2, float var4, long var5);

    public static NVGColor nvgLerpRGBA(NVGColor c0, NVGColor c1, float u, NVGColor __result) {
        NanoVG.nnvgLerpRGBA(c0.address(), c1.address(), u, __result.address());
        return __result;
    }

    public static native void nnvgTransRGBA(long var0, byte var2, long var3);

    public static NVGColor nvgTransRGBA(NVGColor c0, byte a, NVGColor __result) {
        NanoVG.nnvgTransRGBA(c0.address(), a, __result.address());
        return __result;
    }

    public static native void nnvgTransRGBAf(long var0, float var2, long var3);

    public static NVGColor nvgTransRGBAf(NVGColor c0, float a, NVGColor __result) {
        NanoVG.nnvgTransRGBAf(c0.address(), a, __result.address());
        return __result;
    }

    public static native void nnvgHSL(float var0, float var1, float var2, long var3);

    public static NVGColor nvgHSL(float h, float s, float l, NVGColor __result) {
        NanoVG.nnvgHSL(h, s, l, __result.address());
        return __result;
    }

    public static native void nnvgHSLA(float var0, float var1, float var2, byte var3, long var4);

    public static NVGColor nvgHSLA(float h, float s, float l, byte a, NVGColor __result) {
        NanoVG.nnvgHSLA(h, s, l, a, __result.address());
        return __result;
    }

    public static native void nnvgSave(long var0);

    public static void nvgSave(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgSave(ctx);
    }

    public static native void nnvgRestore(long var0);

    public static void nvgRestore(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgRestore(ctx);
    }

    public static native void nnvgReset(long var0);

    public static void nvgReset(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgReset(ctx);
    }

    public static native void nnvgStrokeColor(long var0, long var2);

    public static void nvgStrokeColor(long ctx, NVGColor color) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgStrokeColor(ctx, color.address());
    }

    public static native void nnvgStrokePaint(long var0, long var2);

    public static void nvgStrokePaint(long ctx, NVGPaint paint) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgStrokePaint(ctx, paint.address());
    }

    public static native void nnvgFillColor(long var0, long var2);

    public static void nvgFillColor(long ctx, NVGColor color) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgFillColor(ctx, color.address());
    }

    public static native void nnvgFillPaint(long var0, long var2);

    public static void nvgFillPaint(long ctx, NVGPaint paint) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgFillPaint(ctx, paint.address());
    }

    public static native void nnvgMiterLimit(long var0, float var2);

    public static void nvgMiterLimit(long ctx, float limit) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgMiterLimit(ctx, limit);
    }

    public static native void nnvgStrokeWidth(long var0, float var2);

    public static void nvgStrokeWidth(long ctx, float size) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgStrokeWidth(ctx, size);
    }

    public static native void nnvgLineCap(long var0, int var2);

    public static void nvgLineCap(long ctx, int cap) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgLineCap(ctx, cap);
    }

    public static native void nnvgLineJoin(long var0, int var2);

    public static void nvgLineJoin(long ctx, int join) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgLineJoin(ctx, join);
    }

    public static native void nnvgGlobalAlpha(long var0, float var2);

    public static void nvgGlobalAlpha(long ctx, float alpha) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgGlobalAlpha(ctx, alpha);
    }

    public static native void nnvgResetTransform(long var0);

    public static void nvgResetTransform(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgResetTransform(ctx);
    }

    public static native void nnvgTransform(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    public static void nvgTransform(long ctx, float a, float b, float c, float d, float e, float f) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgTransform(ctx, a, b, c, d, e, f);
    }

    public static native void nnvgTranslate(long var0, float var2, float var3);

    public static void nvgTranslate(long ctx, float x, float y) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgTranslate(ctx, x, y);
    }

    public static native void nnvgRotate(long var0, float var2);

    public static void nvgRotate(long ctx, float angle) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgRotate(ctx, angle);
    }

    public static native void nnvgSkewX(long var0, float var2);

    public static void nvgSkewX(long ctx, float angle) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgSkewX(ctx, angle);
    }

    public static native void nnvgSkewY(long var0, float var2);

    public static void nvgSkewY(long ctx, float angle) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgSkewY(ctx, angle);
    }

    public static native void nnvgScale(long var0, float var2, float var3);

    public static void nvgScale(long ctx, float x, float y) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgScale(ctx, x, y);
    }

    public static native void nnvgCurrentTransform(long var0, long var2);

    public static void nvgCurrentTransform(long ctx, FloatBuffer xform) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.check((Buffer)xform, 6);
        }
        NanoVG.nnvgCurrentTransform(ctx, MemoryUtil.memAddress(xform));
    }

    public static native void nnvgTransformIdentity(long var0);

    public static void nvgTransformIdentity(FloatBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
        }
        NanoVG.nnvgTransformIdentity(MemoryUtil.memAddress(dst));
    }

    public static native void nnvgTransformTranslate(long var0, float var2, float var3);

    public static void nvgTransformTranslate(FloatBuffer dst, float tx, float ty) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
        }
        NanoVG.nnvgTransformTranslate(MemoryUtil.memAddress(dst), tx, ty);
    }

    public static native void nnvgTransformScale(long var0, float var2, float var3);

    public static void nvgTransformScale(FloatBuffer dst, float sx, float sy) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
        }
        NanoVG.nnvgTransformScale(MemoryUtil.memAddress(dst), sx, sy);
    }

    public static native void nnvgTransformRotate(long var0, float var2);

    public static void nvgTransformRotate(FloatBuffer dst, float a) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
        }
        NanoVG.nnvgTransformRotate(MemoryUtil.memAddress(dst), a);
    }

    public static native void nnvgTransformSkewX(long var0, float var2);

    public static void nvgTransformSkewX(FloatBuffer dst, float a) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
        }
        NanoVG.nnvgTransformSkewX(MemoryUtil.memAddress(dst), a);
    }

    public static native void nnvgTransformSkewY(long var0, float var2);

    public static void nvgTransformSkewY(FloatBuffer dst, float a) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
        }
        NanoVG.nnvgTransformSkewY(MemoryUtil.memAddress(dst), a);
    }

    public static native void nnvgTransformMultiply(long var0, long var2);

    public static void nvgTransformMultiply(FloatBuffer dst, FloatBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
            Checks.check((Buffer)src, 6);
        }
        NanoVG.nnvgTransformMultiply(MemoryUtil.memAddress(dst), MemoryUtil.memAddress(src));
    }

    public static native void nnvgTransformPremultiply(long var0, long var2);

    public static void nvgTransformPremultiply(FloatBuffer dst, FloatBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
            Checks.check((Buffer)src, 6);
        }
        NanoVG.nnvgTransformPremultiply(MemoryUtil.memAddress(dst), MemoryUtil.memAddress(src));
    }

    public static native int nnvgTransformInverse(long var0, long var2);

    public static boolean nvgTransformInverse(FloatBuffer dst, FloatBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst, 6);
            Checks.check((Buffer)src, 6);
        }
        return NanoVG.nnvgTransformInverse(MemoryUtil.memAddress(dst), MemoryUtil.memAddress(src)) != 0;
    }

    public static native void nnvgTransformPoint(long var0, long var2, long var4, float var6, float var7);

    public static void nvgTransformPoint(FloatBuffer dstx, FloatBuffer dsty, FloatBuffer xform, float srcx, float srcy) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dstx, 1);
            Checks.check((Buffer)dsty, 1);
            Checks.check((Buffer)xform, 6);
        }
        NanoVG.nnvgTransformPoint(MemoryUtil.memAddress(dstx), MemoryUtil.memAddress(dsty), MemoryUtil.memAddress(xform), srcx, srcy);
    }

    public static native float nvgDegToRad(float var0);

    public static native float nvgRadToDeg(float var0);

    public static native int nnvgCreateImage(long var0, long var2, int var4);

    public static int nvgCreateImage(long ctx, ByteBuffer filename, int imageFlags) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkNT1(filename);
        }
        return NanoVG.nnvgCreateImage(ctx, MemoryUtil.memAddress(filename), imageFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nvgCreateImage(long ctx, CharSequence filename, int imageFlags) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = NanoVG.nnvgCreateImage(ctx, MemoryUtil.memAddress(filenameEncoded), imageFlags);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnvgCreateImageMem(long var0, int var2, long var3, int var5);

    public static int nvgCreateImageMem(long ctx, int imageFlags, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return NanoVG.nnvgCreateImageMem(ctx, imageFlags, MemoryUtil.memAddress(data), data.remaining());
    }

    public static native int nnvgCreateImageRGBA(long var0, int var2, int var3, int var4, long var5);

    public static int nvgCreateImageRGBA(long ctx, int w, int h, int imageFlags, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.check((Buffer)data, w * h * 4);
        }
        return NanoVG.nnvgCreateImageRGBA(ctx, w, h, imageFlags, MemoryUtil.memAddress(data));
    }

    public static native void nnvgUpdateImage(long var0, int var2, long var3);

    public static void nvgUpdateImage(long ctx, int image, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgUpdateImage(ctx, image, MemoryUtil.memAddress(data));
    }

    public static native void nnvgImageSize(long var0, int var2, long var3, long var5);

    public static void nvgImageSize(long ctx, int image, IntBuffer w, IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.check((Buffer)w, 1);
            Checks.check((Buffer)h, 1);
        }
        NanoVG.nnvgImageSize(ctx, image, MemoryUtil.memAddress(w), MemoryUtil.memAddress(h));
    }

    public static native void nnvgDeleteImage(long var0, int var2);

    public static void nvgDeleteImage(long ctx, int image) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgDeleteImage(ctx, image);
    }

    public static native void nnvgLinearGradient(long var0, float var2, float var3, float var4, float var5, long var6, long var8, long var10);

    public static NVGPaint nvgLinearGradient(long ctx, float sx, float sy, float ex, float ey, NVGColor icol, NVGColor ocol, NVGPaint __result) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgLinearGradient(ctx, sx, sy, ex, ey, icol.address(), ocol.address(), __result.address());
        return __result;
    }

    public static native void nnvgBoxGradient(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8, long var10, long var12);

    public static NVGPaint nvgBoxGradient(long ctx, float x, float y, float w, float h, float r, float f, NVGColor icol, NVGColor ocol, NVGPaint __result) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgBoxGradient(ctx, x, y, w, h, r, f, icol.address(), ocol.address(), __result.address());
        return __result;
    }

    public static native void nnvgRadialGradient(long var0, float var2, float var3, float var4, float var5, long var6, long var8, long var10);

    public static NVGPaint nvgRadialGradient(long ctx, float cx, float cy, float inr, float outr, NVGColor icol, NVGColor ocol, NVGPaint __result) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgRadialGradient(ctx, cx, cy, inr, outr, icol.address(), ocol.address(), __result.address());
        return __result;
    }

    public static native void nnvgImagePattern(long var0, float var2, float var3, float var4, float var5, float var6, int var7, float var8, long var9);

    public static NVGPaint nvgImagePattern(long ctx, float ox, float oy, float ex, float ey, float angle, int image, float alpha, NVGPaint __result) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgImagePattern(ctx, ox, oy, ex, ey, angle, image, alpha, __result.address());
        return __result;
    }

    public static native void nnvgScissor(long var0, float var2, float var3, float var4, float var5);

    public static void nvgScissor(long ctx, float x, float y, float w, float h) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgScissor(ctx, x, y, w, h);
    }

    public static native void nnvgIntersectScissor(long var0, float var2, float var3, float var4, float var5);

    public static void nvgIntersectScissor(long ctx, float x, float y, float w, float h) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgIntersectScissor(ctx, x, y, w, h);
    }

    public static native void nnvgResetScissor(long var0);

    public static void nvgResetScissor(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgResetScissor(ctx);
    }

    public static native void nnvgBeginPath(long var0);

    public static void nvgBeginPath(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgBeginPath(ctx);
    }

    public static native void nnvgMoveTo(long var0, float var2, float var3);

    public static void nvgMoveTo(long ctx, float x, float y) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgMoveTo(ctx, x, y);
    }

    public static native void nnvgLineTo(long var0, float var2, float var3);

    public static void nvgLineTo(long ctx, float x, float y) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgLineTo(ctx, x, y);
    }

    public static native void nnvgBezierTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    public static void nvgBezierTo(long ctx, float c1x, float c1y, float c2x, float c2y, float x, float y) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgBezierTo(ctx, c1x, c1y, c2x, c2y, x, y);
    }

    public static native void nnvgQuadTo(long var0, float var2, float var3, float var4, float var5);

    public static void nvgQuadTo(long ctx, float cx, float cy, float x, float y) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgQuadTo(ctx, cx, cy, x, y);
    }

    public static native void nnvgArcTo(long var0, float var2, float var3, float var4, float var5, float var6);

    public static void nvgArcTo(long ctx, float x1, float y1, float x2, float y2, float radius) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgArcTo(ctx, x1, y1, x2, y2, radius);
    }

    public static native void nnvgClosePath(long var0);

    public static void nvgClosePath(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgClosePath(ctx);
    }

    public static native void nnvgPathWinding(long var0, int var2);

    public static void nvgPathWinding(long ctx, int dir) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgPathWinding(ctx, dir);
    }

    public static native void nnvgArc(long var0, float var2, float var3, float var4, float var5, float var6, int var7);

    public static void nvgArc(long ctx, float cx, float cy, float r, float a0, float a1, int dir) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgArc(ctx, cx, cy, r, a0, a1, dir);
    }

    public static native void nnvgRect(long var0, float var2, float var3, float var4, float var5);

    public static void nvgRect(long ctx, float x, float y, float w, float h) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgRect(ctx, x, y, w, h);
    }

    public static native void nnvgRoundedRect(long var0, float var2, float var3, float var4, float var5, float var6);

    public static void nvgRoundedRect(long ctx, float x, float y, float w, float h, float r) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgRoundedRect(ctx, x, y, w, h, r);
    }

    public static native void nnvgRoundedRectVarying(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public static void nvgRoundedRectVarying(long ctx, float x, float y, float w, float h, float radTopLeft, float radTopRight, float radBottomRight, float radBottomLeft) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgRoundedRectVarying(ctx, x, y, w, h, radTopLeft, radTopRight, radBottomRight, radBottomLeft);
    }

    public static native void nnvgEllipse(long var0, float var2, float var3, float var4, float var5);

    public static void nvgEllipse(long ctx, float cx, float cy, float rx, float ry) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgEllipse(ctx, cx, cy, rx, ry);
    }

    public static native void nnvgCircle(long var0, float var2, float var3, float var4);

    public static void nvgCircle(long ctx, float cx, float cy, float r) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgCircle(ctx, cx, cy, r);
    }

    public static native void nnvgFill(long var0);

    public static void nvgFill(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgFill(ctx);
    }

    public static native void nnvgStroke(long var0);

    public static void nvgStroke(long ctx) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgStroke(ctx);
    }

    public static native int nnvgCreateFont(long var0, long var2, long var4);

    public static int nvgCreateFont(long ctx, ByteBuffer name, ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkNT1(name);
            Checks.checkNT1(filename);
        }
        return NanoVG.nnvgCreateFont(ctx, MemoryUtil.memAddress(name), MemoryUtil.memAddress(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nvgCreateFont(long ctx, CharSequence name, CharSequence filename) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = NanoVG.nnvgCreateFont(ctx, MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(filenameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnvgCreateFontMem(long var0, long var2, long var4, int var6, int var7);

    public static int nvgCreateFontMem(long ctx, ByteBuffer name, ByteBuffer data, int freeData) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkNT1(name);
        }
        return NanoVG.nnvgCreateFontMem(ctx, MemoryUtil.memAddress(name), MemoryUtil.memAddress(data), data.remaining(), freeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nvgCreateFontMem(long ctx, CharSequence name, ByteBuffer data, int freeData) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = NanoVG.nnvgCreateFontMem(ctx, MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(data), data.remaining(), freeData);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnvgFindFont(long var0, long var2);

    public static int nvgFindFont(long ctx, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkNT1(name);
        }
        return NanoVG.nnvgFindFont(ctx, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nvgFindFont(long ctx, CharSequence name) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = NanoVG.nnvgFindFont(ctx, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgFontSize(long var0, float var2);

    public static void nvgFontSize(long ctx, float size) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgFontSize(ctx, size);
    }

    public static native void nnvgFontBlur(long var0, float var2);

    public static void nvgFontBlur(long ctx, float blur) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgFontBlur(ctx, blur);
    }

    public static native void nnvgTextLetterSpacing(long var0, float var2);

    public static void nvgTextLetterSpacing(long ctx, float spacing) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgTextLetterSpacing(ctx, spacing);
    }

    public static native void nnvgTextLineHeight(long var0, float var2);

    public static void nvgTextLineHeight(long ctx, float lineHeight) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgTextLineHeight(ctx, lineHeight);
    }

    public static native void nnvgTextAlign(long var0, int var2);

    public static void nvgTextAlign(long ctx, int align) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgTextAlign(ctx, align);
    }

    public static native void nnvgFontFaceId(long var0, int var2);

    public static void nvgFontFaceId(long ctx, int font) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgFontFaceId(ctx, font);
    }

    public static native void nnvgFontFace(long var0, long var2);

    public static void nvgFontFace(long ctx, ByteBuffer font) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkNT1(font);
        }
        NanoVG.nnvgFontFace(ctx, MemoryUtil.memAddress(font));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nvgFontFace(long ctx, CharSequence font) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer fontEncoded = stack.ASCII(font);
            NanoVG.nnvgFontFace(ctx, MemoryUtil.memAddress(fontEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float nnvgText(long var0, float var2, float var3, long var4, long var6);

    public static float nvgText(long ctx, float x, float y, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return NanoVG.nnvgText(ctx, x, y, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nvgText(long ctx, float x, float y, CharSequence string) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            float f = NanoVG.nnvgText(ctx, x, y, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining());
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgTextBox(long var0, float var2, float var3, float var4, long var5, long var7);

    public static void nvgTextBox(long ctx, float x, float y, float breakRowWidth, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        NanoVG.nnvgTextBox(ctx, x, y, breakRowWidth, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nvgTextBox(long ctx, float x, float y, float breakRowWidth, CharSequence string) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            NanoVG.nnvgTextBox(ctx, x, y, breakRowWidth, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float nnvgTextBounds(long var0, float var2, float var3, long var4, long var6, long var8);

    public static float nvgTextBounds(long ctx, float x, float y, ByteBuffer string, FloatBuffer bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe((Buffer)bounds, 4);
        }
        return NanoVG.nnvgTextBounds(ctx, x, y, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining(), MemoryUtil.memAddressSafe(bounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nvgTextBounds(long ctx, float x, float y, CharSequence string, FloatBuffer bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe((Buffer)bounds, 4);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            float f = NanoVG.nnvgTextBounds(ctx, x, y, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining(), MemoryUtil.memAddressSafe(bounds));
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgTextBoxBounds(long var0, float var2, float var3, float var4, long var5, long var7, long var9);

    public static void nvgTextBoxBounds(long ctx, float x, float y, float breakRowWidth, ByteBuffer string, FloatBuffer bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe((Buffer)bounds, 4);
        }
        NanoVG.nnvgTextBoxBounds(ctx, x, y, breakRowWidth, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining(), MemoryUtil.memAddressSafe(bounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nvgTextBoxBounds(long ctx, float x, float y, float breakRowWidth, CharSequence string, FloatBuffer bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe((Buffer)bounds, 4);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            NanoVG.nnvgTextBoxBounds(ctx, x, y, breakRowWidth, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining(), MemoryUtil.memAddressSafe(bounds));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nnvgTextGlyphPositions(long var0, float var2, float var3, long var4, long var6, long var8, int var10);

    public static int nvgTextGlyphPositions(long ctx, float x, float y, ByteBuffer string, NVGGlyphPosition.Buffer positions) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return NanoVG.nnvgTextGlyphPositions(ctx, x, y, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining(), positions.address(), positions.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nvgTextGlyphPositions(long ctx, float x, float y, CharSequence string, NVGGlyphPosition.Buffer positions) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            int n = NanoVG.nnvgTextGlyphPositions(ctx, x, y, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining(), positions.address(), positions.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgTextMetrics(long var0, long var2, long var4, long var6);

    public static void nvgTextMetrics(long ctx, FloatBuffer ascender, FloatBuffer descender, FloatBuffer lineh) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe((Buffer)ascender, 1);
            Checks.checkSafe((Buffer)descender, 1);
            Checks.checkSafe((Buffer)lineh, 1);
        }
        NanoVG.nnvgTextMetrics(ctx, MemoryUtil.memAddressSafe(ascender), MemoryUtil.memAddressSafe(descender), MemoryUtil.memAddressSafe(lineh));
    }

    public static native int nnvgTextBreakLines(long var0, long var2, long var4, float var6, long var7, int var9);

    public static int nvgTextBreakLines(long ctx, ByteBuffer string, float breakRowWidth, NVGTextRow.Buffer rows) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        return NanoVG.nnvgTextBreakLines(ctx, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining(), breakRowWidth, rows.address(), rows.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nvgTextBreakLines(long ctx, CharSequence string, float breakRowWidth, NVGTextRow.Buffer rows) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            int n = NanoVG.nnvgTextBreakLines(ctx, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining(), breakRowWidth, rows.address(), rows.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgCurrentTransform(long var0, float[] var2);

    public static void nvgCurrentTransform(long ctx, float[] xform) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.check(xform, 6);
        }
        NanoVG.nnvgCurrentTransform(ctx, xform);
    }

    public static native void nnvgTransformIdentity(float[] var0);

    public static void nvgTransformIdentity(float[] dst) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
        }
        NanoVG.nnvgTransformIdentity(dst);
    }

    public static native void nnvgTransformTranslate(float[] var0, float var1, float var2);

    public static void nvgTransformTranslate(float[] dst, float tx, float ty) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
        }
        NanoVG.nnvgTransformTranslate(dst, tx, ty);
    }

    public static native void nnvgTransformScale(float[] var0, float var1, float var2);

    public static void nvgTransformScale(float[] dst, float sx, float sy) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
        }
        NanoVG.nnvgTransformScale(dst, sx, sy);
    }

    public static native void nnvgTransformRotate(float[] var0, float var1);

    public static void nvgTransformRotate(float[] dst, float a) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
        }
        NanoVG.nnvgTransformRotate(dst, a);
    }

    public static native void nnvgTransformSkewX(float[] var0, float var1);

    public static void nvgTransformSkewX(float[] dst, float a) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
        }
        NanoVG.nnvgTransformSkewX(dst, a);
    }

    public static native void nnvgTransformSkewY(float[] var0, float var1);

    public static void nvgTransformSkewY(float[] dst, float a) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
        }
        NanoVG.nnvgTransformSkewY(dst, a);
    }

    public static native void nnvgTransformMultiply(float[] var0, float[] var1);

    public static void nvgTransformMultiply(float[] dst, float[] src) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
            Checks.check(src, 6);
        }
        NanoVG.nnvgTransformMultiply(dst, src);
    }

    public static native void nnvgTransformPremultiply(float[] var0, float[] var1);

    public static void nvgTransformPremultiply(float[] dst, float[] src) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
            Checks.check(src, 6);
        }
        NanoVG.nnvgTransformPremultiply(dst, src);
    }

    public static native int nnvgTransformInverse(float[] var0, float[] var1);

    public static boolean nvgTransformInverse(float[] dst, float[] src) {
        if (Checks.CHECKS) {
            Checks.check(dst, 6);
            Checks.check(src, 6);
        }
        return NanoVG.nnvgTransformInverse(dst, src) != 0;
    }

    public static native void nnvgTransformPoint(float[] var0, float[] var1, float[] var2, float var3, float var4);

    public static void nvgTransformPoint(float[] dstx, float[] dsty, float[] xform, float srcx, float srcy) {
        if (Checks.CHECKS) {
            Checks.check(dstx, 1);
            Checks.check(dsty, 1);
            Checks.check(xform, 6);
        }
        NanoVG.nnvgTransformPoint(dstx, dsty, xform, srcx, srcy);
    }

    public static native void nnvgImageSize(long var0, int var2, int[] var3, int[] var4);

    public static void nvgImageSize(long ctx, int image, int[] w, int[] h) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.check(w, 1);
            Checks.check(h, 1);
        }
        NanoVG.nnvgImageSize(ctx, image, w, h);
    }

    public static native float nnvgTextBounds(long var0, float var2, float var3, long var4, long var6, float[] var8);

    public static float nvgTextBounds(long ctx, float x, float y, ByteBuffer string, float[] bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe(bounds, 4);
        }
        return NanoVG.nnvgTextBounds(ctx, x, y, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining(), bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nvgTextBounds(long ctx, float x, float y, CharSequence string, float[] bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe(bounds, 4);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            float f = NanoVG.nnvgTextBounds(ctx, x, y, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining(), bounds);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgTextBoxBounds(long var0, float var2, float var3, float var4, long var5, long var7, float[] var9);

    public static void nvgTextBoxBounds(long ctx, float x, float y, float breakRowWidth, ByteBuffer string, float[] bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe(bounds, 4);
        }
        NanoVG.nnvgTextBoxBounds(ctx, x, y, breakRowWidth, MemoryUtil.memAddress(string), MemoryUtil.memAddress(string) + (long)string.remaining(), bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nvgTextBoxBounds(long ctx, float x, float y, float breakRowWidth, CharSequence string, float[] bounds) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe(bounds, 4);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            NanoVG.nnvgTextBoxBounds(ctx, x, y, breakRowWidth, MemoryUtil.memAddress(stringEncoded), MemoryUtil.memAddress(stringEncoded) + (long)stringEncoded.remaining(), bounds);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nnvgTextMetrics(long var0, float[] var2, float[] var3, float[] var4);

    public static void nvgTextMetrics(long ctx, float[] ascender, float[] descender, float[] lineh) {
        if (Checks.CHECKS) {
            Checks.check(ctx);
            Checks.checkSafe(ascender, 1);
            Checks.checkSafe(descender, 1);
            Checks.checkSafe(lineh, 1);
        }
        NanoVG.nnvgTextMetrics(ctx, ascender, descender, lineh);
    }

    static {
        LibNanoVG.initialize();
    }
}

