/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIVertexWeight
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MVERTEXID;
    public static final int MWEIGHT;

    AIVertexWeight(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIVertexWeight(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIVertexWeight.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mVertexId() {
        return AIVertexWeight.nmVertexId(this.address());
    }

    public float mWeight() {
        return AIVertexWeight.nmWeight(this.address());
    }

    public AIVertexWeight mVertexId(int value) {
        AIVertexWeight.nmVertexId(this.address(), value);
        return this;
    }

    public AIVertexWeight mWeight(float value) {
        AIVertexWeight.nmWeight(this.address(), value);
        return this;
    }

    public AIVertexWeight set(int mVertexId, float mWeight) {
        this.mVertexId(mVertexId);
        this.mWeight(mWeight);
        return this;
    }

    public AIVertexWeight set(AIVertexWeight src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIVertexWeight malloc() {
        return AIVertexWeight.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIVertexWeight calloc() {
        return AIVertexWeight.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIVertexWeight create() {
        return new AIVertexWeight(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIVertexWeight create(long address) {
        return address == 0L ? null : new AIVertexWeight(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIVertexWeight.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIVertexWeight.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIVertexWeight mallocStack() {
        return AIVertexWeight.mallocStack(MemoryStack.stackGet());
    }

    public static AIVertexWeight callocStack() {
        return AIVertexWeight.callocStack(MemoryStack.stackGet());
    }

    public static AIVertexWeight mallocStack(MemoryStack stack) {
        return AIVertexWeight.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIVertexWeight callocStack(MemoryStack stack) {
        return AIVertexWeight.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIVertexWeight.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIVertexWeight.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVertexWeight.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVertexWeight.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmVertexId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MVERTEXID);
    }

    public static float nmWeight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MWEIGHT);
    }

    public static void nmVertexId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MVERTEXID, value);
    }

    public static void nmWeight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MWEIGHT, value);
    }

    static {
        Struct.Layout layout = AIVertexWeight.__struct(AIVertexWeight.__member(4), AIVertexWeight.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MVERTEXID = layout.offsetof(0);
        MWEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVertexWeight, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIVertexWeight newInstance(long address) {
            return new AIVertexWeight(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mVertexId() {
            return AIVertexWeight.nmVertexId(this.address());
        }

        public float mWeight() {
            return AIVertexWeight.nmWeight(this.address());
        }

        public Buffer mVertexId(int value) {
            AIVertexWeight.nmVertexId(this.address(), value);
            return this;
        }

        public Buffer mWeight(float value) {
            AIVertexWeight.nmWeight(this.address(), value);
            return this;
        }
    }
}

