/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.assimp.AITexel;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AITexture
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MWIDTH;
    public static final int MHEIGHT;
    public static final int ACHFORMATHINT;
    public static final int PCDATA;

    AITexture(long address, ByteBuffer container) {
        super(address, container);
    }

    public AITexture(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AITexture.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mWidth() {
        return AITexture.nmWidth(this.address());
    }

    public int mHeight() {
        return AITexture.nmHeight(this.address());
    }

    public ByteBuffer achFormatHint() {
        return AITexture.nachFormatHint(this.address());
    }

    public String achFormatHintString() {
        return AITexture.nachFormatHintString(this.address());
    }

    public AITexel.Buffer pcData(int capacity) {
        return AITexture.npcData(this.address(), capacity);
    }

    public static AITexture create(long address) {
        return address == 0L ? null : new AITexture(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nmWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MWIDTH);
    }

    public static int nmHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MHEIGHT);
    }

    public static ByteBuffer nachFormatHint(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ACHFORMATHINT, 4);
    }

    public static String nachFormatHintString(long struct) {
        return MemoryUtil.memASCII(struct + (long)ACHFORMATHINT);
    }

    public static AITexel.Buffer npcData(long struct, int capacity) {
        return AITexel.create(MemoryUtil.memGetAddress(struct + (long)PCDATA), capacity);
    }

    static {
        Struct.Layout layout = AITexture.__struct(AITexture.__member(4), AITexture.__member(4), AITexture.__array(1, 4), AITexture.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MWIDTH = layout.offsetof(0);
        MHEIGHT = layout.offsetof(1);
        ACHFORMATHINT = layout.offsetof(2);
        PCDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AITexture, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AITexture newInstance(long address) {
            return new AITexture(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mWidth() {
            return AITexture.nmWidth(this.address());
        }

        public int mHeight() {
            return AITexture.nmHeight(this.address());
        }

        public ByteBuffer achFormatHint() {
            return AITexture.nachFormatHint(this.address());
        }

        public String achFormatHintString() {
            return AITexture.nachFormatHintString(this.address());
        }

        public AITexel.Buffer pcData(int capacity) {
            return AITexture.npcData(this.address(), capacity);
        }
    }
}

