/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AITexel
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int B;
    public static final int G;
    public static final int R;
    public static final int A;

    AITexel(long address, ByteBuffer container) {
        super(address, container);
    }

    public AITexel(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AITexel.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public byte b() {
        return AITexel.nb(this.address());
    }

    public byte g() {
        return AITexel.ng(this.address());
    }

    public byte r() {
        return AITexel.nr(this.address());
    }

    public byte a() {
        return AITexel.na(this.address());
    }

    public static AITexel malloc() {
        return AITexel.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AITexel calloc() {
        return AITexel.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AITexel create() {
        return new AITexel(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AITexel create(long address) {
        return address == 0L ? null : new AITexel(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AITexel.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AITexel.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AITexel mallocStack() {
        return AITexel.mallocStack(MemoryStack.stackGet());
    }

    public static AITexel callocStack() {
        return AITexel.callocStack(MemoryStack.stackGet());
    }

    public static AITexel mallocStack(MemoryStack stack) {
        return AITexel.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AITexel callocStack(MemoryStack stack) {
        return AITexel.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AITexel.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AITexel.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AITexel.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AITexel.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nb(long struct) {
        return MemoryUtil.memGetByte(struct + (long)B);
    }

    public static byte ng(long struct) {
        return MemoryUtil.memGetByte(struct + (long)G);
    }

    public static byte nr(long struct) {
        return MemoryUtil.memGetByte(struct + (long)R);
    }

    public static byte na(long struct) {
        return MemoryUtil.memGetByte(struct + (long)A);
    }

    static {
        Struct.Layout layout = AITexel.__struct(AITexel.__member(1), AITexel.__member(1), AITexel.__member(1), AITexel.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        B = layout.offsetof(0);
        G = layout.offsetof(1);
        R = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AITexel, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AITexel newInstance(long address) {
            return new AITexel(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public byte b() {
            return AITexel.nb(this.address());
        }

        public byte g() {
            return AITexel.ng(this.address());
        }

        public byte r() {
            return AITexel.nr(this.address());
        }

        public byte a() {
            return AITexel.na(this.address());
        }
    }
}

