/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIMaterial
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MPROPERTIES;
    public static final int MNUMPROPERTIES;
    public static final int MSTORAGEALLOCATED;

    AIMaterial(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIMaterial(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMaterial.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public PointerBuffer mProperties() {
        return AIMaterial.nmProperties(this.address());
    }

    public int mNumProperties() {
        return AIMaterial.nmNumProperties(this.address());
    }

    public int mStorageAllocated() {
        return AIMaterial.nmStorageAllocated(this.address());
    }

    public AIMaterial mProperties(PointerBuffer value) {
        AIMaterial.nmProperties(this.address(), value);
        return this;
    }

    public AIMaterial mStorageAllocated(int value) {
        AIMaterial.nmStorageAllocated(this.address(), value);
        return this;
    }

    public AIMaterial set(PointerBuffer mProperties, int mStorageAllocated) {
        this.mProperties(mProperties);
        this.mStorageAllocated(mStorageAllocated);
        return this;
    }

    public AIMaterial set(AIMaterial src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIMaterial malloc() {
        return AIMaterial.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIMaterial calloc() {
        return AIMaterial.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIMaterial create() {
        return new AIMaterial(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIMaterial create(long address) {
        return address == 0L ? null : new AIMaterial(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIMaterial.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMaterial.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIMaterial mallocStack() {
        return AIMaterial.mallocStack(MemoryStack.stackGet());
    }

    public static AIMaterial callocStack() {
        return AIMaterial.callocStack(MemoryStack.stackGet());
    }

    public static AIMaterial mallocStack(MemoryStack stack) {
        return AIMaterial.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMaterial callocStack(MemoryStack stack) {
        return AIMaterial.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMaterial.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMaterial.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMaterial.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMaterial.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nmProperties(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MPROPERTIES), AIMaterial.nmNumProperties(struct));
    }

    public static int nmNumProperties(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMPROPERTIES);
    }

    public static int nmStorageAllocated(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MSTORAGEALLOCATED);
    }

    public static void nmProperties(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MPROPERTIES, MemoryUtil.memAddress(value));
        AIMaterial.nmNumProperties(struct, value.remaining());
    }

    public static void nmNumProperties(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMPROPERTIES, value);
    }

    public static void nmStorageAllocated(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MSTORAGEALLOCATED, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MPROPERTIES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMaterial.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIMaterial.__struct(AIMaterial.__member(POINTER_SIZE), AIMaterial.__member(4), AIMaterial.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MPROPERTIES = layout.offsetof(0);
        MNUMPROPERTIES = layout.offsetof(1);
        MSTORAGEALLOCATED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMaterial, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMaterial newInstance(long address) {
            return new AIMaterial(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public PointerBuffer mProperties() {
            return AIMaterial.nmProperties(this.address());
        }

        public int mNumProperties() {
            return AIMaterial.nmNumProperties(this.address());
        }

        public int mStorageAllocated() {
            return AIMaterial.nmStorageAllocated(this.address());
        }

        public Buffer mProperties(PointerBuffer value) {
            AIMaterial.nmProperties(this.address(), value);
            return this;
        }

        public Buffer mStorageAllocated(int value) {
            AIMaterial.nmStorageAllocated(this.address(), value);
            return this;
        }
    }
}

