/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIFileCloseProc;
import org.lwjgl.assimp.AIFileCloseProcI;
import org.lwjgl.assimp.AIFileOpenProc;
import org.lwjgl.assimp.AIFileOpenProcI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIFileIO
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPENPROC;
    public static final int CLOSEPROC;
    public static final int USERDATA;

    AIFileIO(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIFileIO(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIFileIO.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIFileOpenProc OpenProc() {
        return AIFileIO.nOpenProc(this.address());
    }

    public AIFileCloseProc CloseProc() {
        return AIFileIO.nCloseProc(this.address());
    }

    public long UserData() {
        return AIFileIO.nUserData(this.address());
    }

    public AIFileIO OpenProc(AIFileOpenProcI value) {
        AIFileIO.nOpenProc(this.address(), value);
        return this;
    }

    public AIFileIO CloseProc(AIFileCloseProcI value) {
        AIFileIO.nCloseProc(this.address(), value);
        return this;
    }

    public AIFileIO UserData(long value) {
        AIFileIO.nUserData(this.address(), value);
        return this;
    }

    public AIFileIO set(AIFileOpenProcI OpenProc, AIFileCloseProcI CloseProc, long UserData) {
        this.OpenProc(OpenProc);
        this.CloseProc(CloseProc);
        this.UserData(UserData);
        return this;
    }

    public AIFileIO set(AIFileIO src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIFileIO malloc() {
        return AIFileIO.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIFileIO calloc() {
        return AIFileIO.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIFileIO create() {
        return new AIFileIO(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIFileIO create(long address) {
        return address == 0L ? null : new AIFileIO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIFileIO.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIFileIO.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIFileIO mallocStack() {
        return AIFileIO.mallocStack(MemoryStack.stackGet());
    }

    public static AIFileIO callocStack() {
        return AIFileIO.callocStack(MemoryStack.stackGet());
    }

    public static AIFileIO mallocStack(MemoryStack stack) {
        return AIFileIO.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIFileIO callocStack(MemoryStack stack) {
        return AIFileIO.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIFileIO.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIFileIO.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFileIO.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFileIO.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIFileOpenProc nOpenProc(long struct) {
        return AIFileOpenProc.create(MemoryUtil.memGetAddress(struct + (long)OPENPROC));
    }

    public static AIFileCloseProc nCloseProc(long struct) {
        return AIFileCloseProc.create(MemoryUtil.memGetAddress(struct + (long)CLOSEPROC));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static void nOpenProc(long struct, AIFileOpenProcI value) {
        MemoryUtil.memPutAddress(struct + (long)OPENPROC, value.address());
    }

    public static void nCloseProc(long struct, AIFileCloseProcI value) {
        MemoryUtil.memPutAddress(struct + (long)CLOSEPROC, value.address());
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)OPENPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CLOSEPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)USERDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIFileIO.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIFileIO.__struct(AIFileIO.__member(POINTER_SIZE), AIFileIO.__member(POINTER_SIZE), AIFileIO.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPENPROC = layout.offsetof(0);
        CLOSEPROC = layout.offsetof(1);
        USERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIFileIO, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIFileIO newInstance(long address) {
            return new AIFileIO(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIFileOpenProc OpenProc() {
            return AIFileIO.nOpenProc(this.address());
        }

        public AIFileCloseProc CloseProc() {
            return AIFileIO.nCloseProc(this.address());
        }

        public long UserData() {
            return AIFileIO.nUserData(this.address());
        }

        public Buffer OpenProc(AIFileOpenProcI value) {
            AIFileIO.nOpenProc(this.address(), value);
            return this;
        }

        public Buffer CloseProc(AIFileCloseProcI value) {
            AIFileIO.nCloseProc(this.address(), value);
            return this;
        }

        public Buffer UserData(long value) {
            AIFileIO.nUserData(this.address(), value);
            return this;
        }
    }
}

