/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIExportFormatDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int DESCRIPTION;
    public static final int FILEEXTENSION;

    AIExportFormatDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIExportFormatDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIExportFormatDesc.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer id() {
        return AIExportFormatDesc.nid(this.address());
    }

    public String idString() {
        return AIExportFormatDesc.nidString(this.address());
    }

    public ByteBuffer description() {
        return AIExportFormatDesc.ndescription(this.address());
    }

    public String descriptionString() {
        return AIExportFormatDesc.ndescriptionString(this.address());
    }

    public ByteBuffer fileExtension() {
        return AIExportFormatDesc.nfileExtension(this.address());
    }

    public String fileExtensionString() {
        return AIExportFormatDesc.nfileExtensionString(this.address());
    }

    public AIExportFormatDesc id(ByteBuffer value) {
        AIExportFormatDesc.nid(this.address(), value);
        return this;
    }

    public AIExportFormatDesc description(ByteBuffer value) {
        AIExportFormatDesc.ndescription(this.address(), value);
        return this;
    }

    public AIExportFormatDesc fileExtension(ByteBuffer value) {
        AIExportFormatDesc.nfileExtension(this.address(), value);
        return this;
    }

    public AIExportFormatDesc set(ByteBuffer id, ByteBuffer description, ByteBuffer fileExtension) {
        this.id(id);
        this.description(description);
        this.fileExtension(fileExtension);
        return this;
    }

    public AIExportFormatDesc set(AIExportFormatDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIExportFormatDesc malloc() {
        return AIExportFormatDesc.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIExportFormatDesc calloc() {
        return AIExportFormatDesc.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIExportFormatDesc create() {
        return new AIExportFormatDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIExportFormatDesc create(long address) {
        return address == 0L ? null : new AIExportFormatDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIExportFormatDesc.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIExportFormatDesc.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIExportFormatDesc mallocStack() {
        return AIExportFormatDesc.mallocStack(MemoryStack.stackGet());
    }

    public static AIExportFormatDesc callocStack() {
        return AIExportFormatDesc.callocStack(MemoryStack.stackGet());
    }

    public static AIExportFormatDesc mallocStack(MemoryStack stack) {
        return AIExportFormatDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIExportFormatDesc callocStack(MemoryStack stack) {
        return AIExportFormatDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIExportFormatDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIExportFormatDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIExportFormatDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIExportFormatDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nid(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)ID));
    }

    public static String nidString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)ID));
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    public static ByteBuffer nfileExtension(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)FILEEXTENSION));
    }

    public static String nfileExtensionString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)FILEEXTENSION));
    }

    public static void nid(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)ID, MemoryUtil.memAddress(value));
    }

    public static void ndescription(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)DESCRIPTION, MemoryUtil.memAddress(value));
    }

    public static void nfileExtension(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)FILEEXTENSION, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ID));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILEEXTENSION));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIExportFormatDesc.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIExportFormatDesc.__struct(AIExportFormatDesc.__member(POINTER_SIZE), AIExportFormatDesc.__member(POINTER_SIZE), AIExportFormatDesc.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        DESCRIPTION = layout.offsetof(1);
        FILEEXTENSION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIExportFormatDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIExportFormatDesc newInstance(long address) {
            return new AIExportFormatDesc(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer id() {
            return AIExportFormatDesc.nid(this.address());
        }

        public String idString() {
            return AIExportFormatDesc.nidString(this.address());
        }

        public ByteBuffer description() {
            return AIExportFormatDesc.ndescription(this.address());
        }

        public String descriptionString() {
            return AIExportFormatDesc.ndescriptionString(this.address());
        }

        public ByteBuffer fileExtension() {
            return AIExportFormatDesc.nfileExtension(this.address());
        }

        public String fileExtensionString() {
            return AIExportFormatDesc.nfileExtensionString(this.address());
        }

        public Buffer id(ByteBuffer value) {
            AIExportFormatDesc.nid(this.address(), value);
            return this;
        }

        public Buffer description(ByteBuffer value) {
            AIExportFormatDesc.ndescription(this.address(), value);
            return this;
        }

        public Buffer fileExtension(ByteBuffer value) {
            AIExportFormatDesc.nfileExtension(this.address(), value);
            return this;
        }
    }
}

