/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIExportDataBlob
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int DATA;
    public static final int NAME;
    public static final int NEXT;

    AIExportDataBlob(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIExportDataBlob(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIExportDataBlob.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long size() {
        return AIExportDataBlob.nsize(this.address());
    }

    public ByteBuffer data() {
        return AIExportDataBlob.ndata(this.address());
    }

    public AIString name() {
        return AIExportDataBlob.nname(this.address());
    }

    public AIExportDataBlob next() {
        return AIExportDataBlob.nnext(this.address());
    }

    public AIExportDataBlob data(ByteBuffer value) {
        AIExportDataBlob.ndata(this.address(), value);
        return this;
    }

    public AIExportDataBlob name(AIString value) {
        AIExportDataBlob.nname(this.address(), value);
        return this;
    }

    public AIExportDataBlob next(AIExportDataBlob value) {
        AIExportDataBlob.nnext(this.address(), value);
        return this;
    }

    public AIExportDataBlob set(ByteBuffer data, AIString name, AIExportDataBlob next) {
        this.data(data);
        this.name(name);
        this.next(next);
        return this;
    }

    public AIExportDataBlob set(AIExportDataBlob src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIExportDataBlob malloc() {
        return AIExportDataBlob.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIExportDataBlob calloc() {
        return AIExportDataBlob.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIExportDataBlob create() {
        return new AIExportDataBlob(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIExportDataBlob create(long address) {
        return address == 0L ? null : new AIExportDataBlob(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIExportDataBlob.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIExportDataBlob.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIExportDataBlob mallocStack() {
        return AIExportDataBlob.mallocStack(MemoryStack.stackGet());
    }

    public static AIExportDataBlob callocStack() {
        return AIExportDataBlob.callocStack(MemoryStack.stackGet());
    }

    public static AIExportDataBlob mallocStack(MemoryStack stack) {
        return AIExportDataBlob.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIExportDataBlob callocStack(MemoryStack stack) {
        return AIExportDataBlob.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIExportDataBlob.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIExportDataBlob.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIExportDataBlob.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIExportDataBlob.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), (int)AIExportDataBlob.nsize(struct));
    }

    public static AIString nname(long struct) {
        return AIString.create(struct + (long)NAME);
    }

    public static AIExportDataBlob nnext(long struct) {
        return AIExportDataBlob.create(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        AIExportDataBlob.nsize(struct, value.remaining());
    }

    public static void nname(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NAME), (int)AIString.SIZEOF);
    }

    public static void nnext(long struct, AIExportDataBlob value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, AIExportDataBlob.addressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIExportDataBlob.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIExportDataBlob.__struct(AIExportDataBlob.__member(POINTER_SIZE), AIExportDataBlob.__member(POINTER_SIZE), AIExportDataBlob.__member(AIString.SIZEOF, AIString.ALIGNOF), AIExportDataBlob.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        DATA = layout.offsetof(1);
        NAME = layout.offsetof(2);
        NEXT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIExportDataBlob, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIExportDataBlob newInstance(long address) {
            return new AIExportDataBlob(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long size() {
            return AIExportDataBlob.nsize(this.address());
        }

        public ByteBuffer data() {
            return AIExportDataBlob.ndata(this.address());
        }

        public AIString name() {
            return AIExportDataBlob.nname(this.address());
        }

        public AIExportDataBlob next() {
            return AIExportDataBlob.nnext(this.address());
        }

        public Buffer data(ByteBuffer value) {
            AIExportDataBlob.ndata(this.address(), value);
            return this;
        }

        public Buffer name(AIString value) {
            AIExportDataBlob.nname(this.address(), value);
            return this;
        }

        public Buffer next(AIExportDataBlob value) {
            AIExportDataBlob.nnext(this.address(), value);
            return this;
        }
    }
}

