/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIColor3D
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;

    AIColor3D(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIColor3D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIColor3D.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return AIColor3D.nr(this.address());
    }

    public float g() {
        return AIColor3D.ng(this.address());
    }

    public float b() {
        return AIColor3D.nb(this.address());
    }

    public static AIColor3D create(long address) {
        return address == 0L ? null : new AIColor3D(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)R);
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)G);
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)B);
    }

    static {
        Struct.Layout layout = AIColor3D.__struct(AIColor3D.__member(4), AIColor3D.__member(4), AIColor3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIColor3D, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIColor3D newInstance(long address) {
            return new AIColor3D(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float r() {
            return AIColor3D.nr(this.address());
        }

        public float g() {
            return AIColor3D.ng(this.address());
        }

        public float b() {
            return AIColor3D.nb(this.address());
        }
    }
}

