/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIAnimation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MDURATION;
    public static final int MTICKSPERSECOND;
    public static final int MNUMCHANNELS;
    public static final int MCHANNELS;
    public static final int MNUMMESHCHANNELS;
    public static final int MMESHCHANNELS;

    AIAnimation(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIAnimation(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIAnimation.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIString mName() {
        return AIAnimation.nmName(this.address());
    }

    public double mDuration() {
        return AIAnimation.nmDuration(this.address());
    }

    public double mTicksPerSecond() {
        return AIAnimation.nmTicksPerSecond(this.address());
    }

    public int mNumChannels() {
        return AIAnimation.nmNumChannels(this.address());
    }

    public PointerBuffer mChannels() {
        return AIAnimation.nmChannels(this.address());
    }

    public int mNumMeshChannels() {
        return AIAnimation.nmNumMeshChannels(this.address());
    }

    public PointerBuffer mMeshChannels() {
        return AIAnimation.nmMeshChannels(this.address());
    }

    public AIAnimation mName(AIString value) {
        AIAnimation.nmName(this.address(), value);
        return this;
    }

    public AIAnimation mDuration(double value) {
        AIAnimation.nmDuration(this.address(), value);
        return this;
    }

    public AIAnimation mTicksPerSecond(double value) {
        AIAnimation.nmTicksPerSecond(this.address(), value);
        return this;
    }

    public AIAnimation mChannels(PointerBuffer value) {
        AIAnimation.nmChannels(this.address(), value);
        return this;
    }

    public AIAnimation mMeshChannels(PointerBuffer value) {
        AIAnimation.nmMeshChannels(this.address(), value);
        return this;
    }

    public AIAnimation set(AIString mName, double mDuration, double mTicksPerSecond, PointerBuffer mChannels, PointerBuffer mMeshChannels) {
        this.mName(mName);
        this.mDuration(mDuration);
        this.mTicksPerSecond(mTicksPerSecond);
        this.mChannels(mChannels);
        this.mMeshChannels(mMeshChannels);
        return this;
    }

    public AIAnimation set(AIAnimation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIAnimation malloc() {
        return AIAnimation.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIAnimation calloc() {
        return AIAnimation.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIAnimation create() {
        return new AIAnimation(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIAnimation create(long address) {
        return address == 0L ? null : new AIAnimation(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIAnimation.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIAnimation.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIAnimation mallocStack() {
        return AIAnimation.mallocStack(MemoryStack.stackGet());
    }

    public static AIAnimation callocStack() {
        return AIAnimation.callocStack(MemoryStack.stackGet());
    }

    public static AIAnimation mallocStack(MemoryStack stack) {
        return AIAnimation.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIAnimation callocStack(MemoryStack stack) {
        return AIAnimation.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIAnimation.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIAnimation.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAnimation.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAnimation.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static double nmDuration(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MDURATION);
    }

    public static double nmTicksPerSecond(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MTICKSPERSECOND);
    }

    public static int nmNumChannels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMCHANNELS);
    }

    public static PointerBuffer nmChannels(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MCHANNELS), AIAnimation.nmNumChannels(struct));
    }

    public static int nmNumMeshChannels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMMESHCHANNELS);
    }

    public static PointerBuffer nmMeshChannels(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MMESHCHANNELS), AIAnimation.nmNumMeshChannels(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (int)AIString.SIZEOF);
    }

    public static void nmDuration(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MDURATION, value);
    }

    public static void nmTicksPerSecond(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MTICKSPERSECOND, value);
    }

    public static void nmNumChannels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMCHANNELS, value);
    }

    public static void nmChannels(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCHANNELS, MemoryUtil.memAddress(value));
        AIAnimation.nmNumChannels(struct, value.remaining());
    }

    public static void nmNumMeshChannels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMMESHCHANNELS, value);
    }

    public static void nmMeshChannels(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHCHANNELS, MemoryUtil.memAddress(value));
        AIAnimation.nmNumMeshChannels(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MCHANNELS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHCHANNELS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIAnimation.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIAnimation.__struct(AIAnimation.__member(AIString.SIZEOF, AIString.ALIGNOF), AIAnimation.__member(8), AIAnimation.__member(8), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MDURATION = layout.offsetof(1);
        MTICKSPERSECOND = layout.offsetof(2);
        MNUMCHANNELS = layout.offsetof(3);
        MCHANNELS = layout.offsetof(4);
        MNUMMESHCHANNELS = layout.offsetof(5);
        MMESHCHANNELS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<AIAnimation, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIAnimation newInstance(long address) {
            return new AIAnimation(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIString mName() {
            return AIAnimation.nmName(this.address());
        }

        public double mDuration() {
            return AIAnimation.nmDuration(this.address());
        }

        public double mTicksPerSecond() {
            return AIAnimation.nmTicksPerSecond(this.address());
        }

        public int mNumChannels() {
            return AIAnimation.nmNumChannels(this.address());
        }

        public PointerBuffer mChannels() {
            return AIAnimation.nmChannels(this.address());
        }

        public int mNumMeshChannels() {
            return AIAnimation.nmNumMeshChannels(this.address());
        }

        public PointerBuffer mMeshChannels() {
            return AIAnimation.nmMeshChannels(this.address());
        }

        public Buffer mName(AIString value) {
            AIAnimation.nmName(this.address(), value);
            return this;
        }

        public Buffer mDuration(double value) {
            AIAnimation.nmDuration(this.address(), value);
            return this;
        }

        public Buffer mTicksPerSecond(double value) {
            AIAnimation.nmTicksPerSecond(this.address(), value);
            return this;
        }

        public Buffer mChannels(PointerBuffer value) {
            AIAnimation.nmChannels(this.address(), value);
            return this;
        }

        public Buffer mMeshChannels(PointerBuffer value) {
            AIAnimation.nmMeshChannels(this.address(), value);
            return this;
        }
    }
}

