/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix3x2dc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;

public class Vector2d
implements Externalizable,
Vector2dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Vector2d() {
    }

    public Vector2d(double d) {
        this(d, d);
    }

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d(Vector2dc v) {
        this.x = v.x();
        this.y = v.y();
    }

    public Vector2d(Vector2fc v) {
        this.x = v.x();
        this.y = v.y();
    }

    public Vector2d(Vector2ic v) {
        this.x = v.x();
        this.y = v.y();
    }

    public Vector2d(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2d(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector2d(DoubleBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2d(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public Vector2d set(double d) {
        return this.set(d, d);
    }

    public Vector2d set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2d set(Vector2dc v) {
        this.x = v.x();
        this.y = v.y();
        return this;
    }

    public Vector2d set(Vector2fc v) {
        this.x = v.x();
        this.y = v.y();
        return this;
    }

    public Vector2d set(Vector2ic v) {
        this.x = v.x();
        this.y = v.y();
        return this;
    }

    public Vector2d set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2d set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector2d set(DoubleBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2d set(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector2d setComponent(int component, double value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public DoubleBuffer get(DoubleBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public DoubleBuffer get(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector2d perpendicular() {
        return this.set(this.y, this.x * -1.0);
    }

    public Vector2d sub(Vector2dc v) {
        this.x -= v.x();
        this.y -= v.y();
        return this;
    }

    public Vector2d sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2d sub(double x, double y, Vector2d dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        return dest;
    }

    public Vector2d sub(Vector2fc v) {
        this.x -= (double)v.x();
        this.y -= (double)v.y();
        return this;
    }

    public Vector2d sub(Vector2dc v, Vector2d dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        return dest;
    }

    public Vector2d sub(Vector2fc v, Vector2d dest) {
        dest.x = this.x + (double)v.x();
        dest.y = this.y + (double)v.y();
        return dest;
    }

    public Vector2d mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2d mul(double scalar, Vector2d dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        return dest;
    }

    public Vector2d mul(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2d mul(double x, double y, Vector2d dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        return dest;
    }

    public Vector2d mul(Vector2dc v) {
        this.x *= v.x();
        this.y *= v.y();
        return this;
    }

    public Vector2d mul(Vector2dc v, Vector2d dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        return dest;
    }

    public Vector2d mulPosition(Matrix3x2dc mat) {
        return this.mulPosition(mat, this);
    }

    public Vector2d mulPosition(Matrix3x2dc mat, Vector2d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20(), mat.m01() * this.x + mat.m11() * this.y + mat.m21());
        return dest;
    }

    public Vector2d mulDirection(Matrix3x2dc mat) {
        return this.mulPosition(mat, this);
    }

    public Vector2d mulDirection(Matrix3x2dc mat, Vector2d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y, mat.m01() * this.x + mat.m11() * this.y);
        return dest;
    }

    public double dot(Vector2dc v) {
        return this.x * v.x() + this.y * v.y();
    }

    public double angle(Vector2dc v) {
        double dot = this.x * v.x() + this.y * v.y();
        double det = this.x * v.y() - this.y * v.x();
        return Math.atan2(det, dot);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distance(Vector2dc v) {
        return this.distance(v.x(), v.y());
    }

    public double distance(Vector2fc v) {
        return this.distance(v.x(), v.y());
    }

    public double distance(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Vector2d normalize() {
        double invLength = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x *= invLength;
        this.y *= invLength;
        return this;
    }

    public Vector2d normalize(Vector2d dest) {
        double invLength = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        return dest;
    }

    public Vector2d normalize(double length) {
        double invLength = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y) * length;
        this.x *= invLength;
        this.y *= invLength;
        return this;
    }

    public Vector2d normalize(double length, Vector2d dest) {
        double invLength = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y) * length;
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        return dest;
    }

    public Vector2d add(Vector2dc v) {
        this.x += v.x();
        this.y += v.y();
        return this;
    }

    public Vector2d add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2d add(double x, double y, Vector2d dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        return dest;
    }

    public Vector2d add(Vector2fc v) {
        this.x += (double)v.x();
        this.y += (double)v.y();
        return this;
    }

    public Vector2d add(Vector2dc v, Vector2d dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        return dest;
    }

    public Vector2d add(Vector2fc v, Vector2d dest) {
        dest.x = this.x + (double)v.x();
        dest.y = this.y + (double)v.y();
        return dest;
    }

    public Vector2d zero() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
    }

    public Vector2d negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2d negate(Vector2d dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public Vector2d lerp(Vector2dc other, double t) {
        return this.lerp(other, t, this);
    }

    public Vector2d lerp(Vector2dc other, double t, Vector2d dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2d other = (Vector2d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + ")";
    }

    public Vector2d fma(Vector2dc a, Vector2dc b) {
        this.x += a.x() * b.x();
        this.y += a.y() * b.y();
        return this;
    }

    public Vector2d fma(double a, Vector2dc b) {
        this.x += a * b.x();
        this.y += a * b.y();
        return this;
    }

    public Vector2d fma(Vector2dc a, Vector2dc b, Vector2d dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        return dest;
    }

    public Vector2d fma(double a, Vector2dc b, Vector2d dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        return dest;
    }
}

