/*
 * Decompiled with CFR 0.152.
 */
package nonlinearities;

import nonlinearities.Nonlinearity;

public class ExponentialLinearUnit
implements Nonlinearity {
    public final double slope;

    public ExponentialLinearUnit(double slope) {
        this.slope = slope;
    }

    @Override
    public double forward(double x) {
        if (x > 0.0) {
            return x;
        }
        return this.slope * (Math.exp(x) - 1.0);
    }

    @Override
    public double backward(double x) {
        if (x > 0.0) {
            return 1.0;
        }
        return this.forward(x) + this.slope;
    }
}

