/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import gnu.trove.impl.sync.TSynchronizedLongObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Formatter;
import java.util.TimeZone;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.Helpers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class MiscUtil {
    public static final long DISCORD_EPOCH = 1420070400000L;
    public static final long TIMESTAMP_OFFSET = 22L;
    private static final DateTimeFormatter dtFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;

    public static long getDiscordTimestamp(long millisTimestamp) {
        return (millisTimestamp << 22) + 1420070400000L;
    }

    public static OffsetDateTime getCreationTime(long entityId) {
        long timestamp = (entityId >>> 22) + 1420070400000L;
        Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmt.setTimeInMillis(timestamp);
        return OffsetDateTime.ofInstant(gmt.toInstant(), gmt.getTimeZone().toZoneId());
    }

    public static OffsetDateTime getCreationTime(ISnowflake entity) {
        Checks.notNull(entity, "Entity");
        return MiscUtil.getCreationTime(entity.getIdLong());
    }

    public static String getDateTimeString(OffsetDateTime time) {
        return time.format(dtFormatter);
    }

    public static int getShardForGuild(long guildId, int shards) {
        return (int)((guildId >>> 22) % (long)shards);
    }

    public static int getShardForGuild(String guildId, int shards) {
        return MiscUtil.getShardForGuild(MiscUtil.parseSnowflake(guildId), shards);
    }

    public static int getShardForGuild(Guild guild, int shards) {
        return MiscUtil.getShardForGuild(guild.getIdLong(), shards);
    }

    public static <T> TLongObjectMap<T> newLongMap() {
        return new TSynchronizedLongObjectMap(new TLongObjectHashMap(), new Object());
    }

    public static String encodeUTF8(String chars) {
        try {
            return URLEncoder.encode(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long parseSnowflake(String input) {
        Checks.notEmpty(input, "ID");
        try {
            if (!input.startsWith("-")) {
                return Long.parseUnsignedLong(input);
            }
            return Long.parseLong(input);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(String.format("The specified ID is not a valid snowflake (%s). Expecting a valid long value!", input));
        }
    }

    public static void appendTo(Formatter formatter, int width, int precision, boolean leftJustified, String out) {
        try {
            Appendable appendable = formatter.out();
            if (precision > -1 && out.length() > precision) {
                appendable.append(Helpers.truncate(out, precision));
                return;
            }
            if (leftJustified) {
                appendable.append(Helpers.rightPad(out, width));
            } else {
                appendable.append(Helpers.leftPad(out, width));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RequestBody createRequestBody(final MediaType contentType, final InputStream stream) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source(stream);){
                    sink.writeAll(source);
                }
            }
        };
    }
}

