/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.requests.WebSocketClient;

@Deprecated
public class SessionReconnectQueue {
    public static final int RECONNECT_DELAY = 5000;
    protected final Object lock = new Object();
    protected final BlockingQueue<WebSocketClient> reconnectQueue;
    protected volatile Thread reconnectThread;

    public SessionReconnectQueue() {
        this(new LinkedBlockingQueue<WebSocketClient>());
    }

    public SessionReconnectQueue(BlockingQueue<WebSocketClient> reconnectQueue) {
        this.reconnectQueue = reconnectQueue;
    }

    public void appendSession(WebSocketClient client) {
        if (!this.reconnectQueue.offer(client)) {
            throw new IllegalStateException("Queue rejected session");
        }
        this.runWorker();
    }

    public void removeSession(WebSocketClient client) {
        this.reconnectQueue.remove(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWorker() {
        Object object = this.lock;
        synchronized (object) {
            if (this.reconnectThread == null) {
                this.reconnectThread = new ReconnectThread();
            }
        }
    }

    protected final class ReconnectThread
    extends Thread {
        protected ReconnectThread() {
            super("JDA-ReconnectThread");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean isFirst = true;
            while (!SessionReconnectQueue.this.reconnectQueue.isEmpty()) {
                try {
                    WebSocketClient client = (WebSocketClient)SessionReconnectQueue.this.reconnectQueue.poll();
                    client.reconnect(true, isFirst);
                    isFirst = false;
                    if (SessionReconnectQueue.this.reconnectQueue.isEmpty()) continue;
                    while (client.getJDA().getStatus().ordinal() < JDA.Status.AWAITING_LOGIN_CONFIRMATION.ordinal()) {
                        Thread.sleep(50L);
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            Object object = SessionReconnectQueue.this.lock;
            synchronized (object) {
                SessionReconnectQueue.this.reconnectThread = null;
                if (!SessionReconnectQueue.this.reconnectQueue.isEmpty()) {
                    SessionReconnectQueue.this.runWorker();
                }
            }
        }
    }
}

