/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.core.utils.JDALogger;
import org.slf4j.Logger;

public class EventCache {
    public static final Logger LOG = JDALogger.getLog(EventCache.class);
    private final Map<Type, TLongObjectMap<List<Runnable>>> eventCache = new HashMap<Type, TLongObjectMap<List<Runnable>>>();

    public void cache(Type type, long triggerId, Runnable handler) {
        TLongObjectMap triggerCache = this.eventCache.computeIfAbsent(type, k -> new TLongObjectHashMap());
        LinkedList<Runnable> items = (LinkedList<Runnable>)triggerCache.get(triggerId);
        if (items == null) {
            items = new LinkedList<Runnable>();
            triggerCache.put(triggerId, items);
        }
        items.add(handler);
    }

    public void playbackCache(Type type, long triggerId) {
        List<Runnable> items;
        try {
            items = this.eventCache.get((Object)type).get(triggerId);
        }
        catch (NullPointerException e) {
            return;
        }
        if (items != null && !items.isEmpty()) {
            LOG.debug("Replaying {} events from the EventCache for a {} with id: {}", new Object[]{items.size(), type, triggerId});
            LinkedList<Runnable> itemsCopy = new LinkedList<Runnable>(items);
            items.clear();
            for (Runnable item : itemsCopy) {
                item.run();
            }
        }
    }

    public int size() {
        return (int)this.eventCache.values().stream().mapToLong(typeMap -> typeMap.valueCollection().stream().mapToLong(List::size).sum()).sum();
    }

    public void clear() {
        this.eventCache.clear();
    }

    public void clear(Type type, long id) {
        try {
            List<Runnable> events = this.eventCache.get((Object)type).remove(id);
            LOG.debug("Clearing cache for type {} with ID {} (Size: {})", new Object[]{type, id, events.size()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static enum Type {
        USER,
        GUILD,
        CHANNEL,
        ROLE,
        RELATIONSHIP,
        CALL;

    }
}

