/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import matrix.Matrix;
import matrix.Tensor;
import model.TensorLayer;
import nonlinearities.Nonlinearity;

public class ConvNonlinLayer
implements TensorLayer {
    private Nonlinearity nonlin;

    public ConvNonlinLayer(Nonlinearity nonlin) {
        this.nonlin = nonlin;
    }

    @Override
    public Tensor forward(Tensor t, Graph g) throws Exception {
        Tensor toReturn = new Tensor(t.width, t.height, t.depth);
        int i = 0;
        while (i < t.depth) {
            toReturn.matrices[i] = g.nonlin(this.nonlin, t.matrices[i]);
            ++i;
        }
        return toReturn;
    }

    @Override
    public void resetState() {
    }

    @Override
    public List<Matrix> getParameters() {
        return null;
    }

    @Override
    public TensorLayer clone() {
        return new ConvNonlinLayer(this.nonlin);
    }

    @Override
    public void saveState(DataOutputStream fos) throws Exception {
    }

    @Override
    public void loadState(DataInputStream fis) throws Exception {
    }
}

