/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import matrix.Matrix;
import matrix.Tensor;
import model.DenseLayer;
import model.TensorLayer;

public class ConvDense
implements TensorLayer {
    private DenseLayer dense;

    public ConvDense(DenseLayer dense) {
        this.dense = dense;
    }

    @Override
    public Tensor forward(Tensor input, Graph g) throws Exception {
        if (input.depth != 1) {
            throw new Exception("Invalid tensor depth: Is " + Integer.toString(input.depth) + ", expected: 1");
        }
        Matrix m = this.dense.forward(input.matrices[0], g);
        Tensor toReturn = new Tensor(m);
        return toReturn;
    }

    @Override
    public void resetState() {
        this.dense.resetState();
    }

    @Override
    public List<Matrix> getParameters() {
        return this.dense.getParameters();
    }

    public DenseLayer getDenseLayer() {
        return this.dense;
    }

    @Override
    public void saveState(DataOutputStream fos) throws Exception {
        this.dense.saveState(fos);
    }

    @Override
    public void loadState(DataInputStream fis) throws Exception {
        this.dense.loadState(fis);
    }

    @Override
    public TensorLayer clone() {
        return new ConvDense(this.dense.clone());
    }
}

