/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import matrix.Matrix;

public class Tensor {
    public Matrix[] matrices;
    public int width;
    public int height;
    public int depth;

    public Tensor(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.matrices = new Matrix[depth];
        int i = 0;
        while (i < depth) {
            this.matrices[i] = new Matrix(height, width);
            ++i;
        }
    }

    public Tensor(int width, int height, int depth, boolean isParameter) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.matrices = new Matrix[depth];
        int i = 0;
        while (i < depth) {
            this.matrices[i] = new Matrix(height, width, isParameter);
            ++i;
        }
    }

    public Tensor(double[] vec) {
        this(1, vec.length, 1);
        this.matrices[0].w = vec;
    }

    public Tensor(Matrix m) {
        this.width = m.cols;
        this.height = m.rows;
        this.depth = 1;
        this.matrices = new Matrix[]{m};
    }

    public static Tensor rand(int width, int height, int depth, double initParamStdDev, Random random) {
        Tensor toReturn = new Tensor(width, height, depth);
        Matrix[] matrixArray = toReturn.matrices;
        int n = toReturn.matrices.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            int i = 0;
            while (i < m.w.length) {
                m.w[i] = (2.0 * random.nextDouble() - 1.0) * initParamStdDev;
                ++i;
            }
            ++n2;
        }
        return toReturn;
    }

    public double getValueAt(int x, int y, int z) {
        return this.matrices[z].getW(y, x);
    }

    public void setValueAt(int x, int y, int z, double val) {
        this.matrices[z].setW(y, x, val);
    }

    public void save(DataOutputStream fos) throws Exception {
        fos.writeInt(this.width);
        fos.writeInt(this.height);
        fos.writeInt(this.depth);
        Matrix[] matrixArray = this.matrices;
        int n = this.matrices.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            m.save(fos);
            ++n2;
        }
    }

    public void load(DataInputStream fis) throws Exception {
        this.width = fis.readInt();
        this.height = fis.readInt();
        this.depth = fis.readInt();
        this.matrices = new Matrix[this.depth];
        int i = 0;
        while (i < this.matrices.length) {
            this.matrices[i] = new Matrix(1, 1);
            this.matrices[i].load(fis);
            ++i;
        }
    }

    public Tensor clone() {
        Tensor clone = new Tensor(this.width, this.height, 0);
        clone.matrices = new Matrix[this.depth];
        clone.depth = this.depth;
        int i = 0;
        while (i < this.depth) {
            clone.matrices[i] = this.matrices[i].clone();
            ++i;
        }
        return clone;
    }
}

