/*
 * Decompiled with CFR 0.152.
 */
package loss;

import loss.Loss;
import matrix.Matrix;

public class LossLogLoss
implements Loss {
    @Override
    public void backward(Matrix actualOutput, Matrix targetOutput) throws Exception {
        int i = 0;
        while (i < targetOutput.w.length) {
            if (targetOutput.w[i] == 1.0) {
                if (actualOutput.w[i] == 0.0) {
                    actualOutput.w[i] = 1.0E-8;
                }
                int n = i;
                actualOutput.dw[n] = actualOutput.dw[n] + -1.0 / actualOutput.w[i];
            } else if (targetOutput.w[i] == 0.0) {
                if (actualOutput.w[i] == 1.0) {
                    actualOutput.w[i] = 0.99999999;
                }
                int n = i;
                actualOutput.dw[n] = actualOutput.dw[n] + 1.0 / (1.0 - actualOutput.w[i]);
            } else {
                throw new Exception("Invalid target");
            }
            ++i;
        }
    }

    @Override
    public double measure(Matrix actualOutput, Matrix targetOutput) throws Exception {
        double sum = 0.0;
        int i = 0;
        while (i < targetOutput.w.length) {
            if (targetOutput.w[i] == 1.0) {
                if (actualOutput.w[i] == 0.0) {
                    actualOutput.w[i] = 1.0E-8;
                }
                sum += -Math.log(actualOutput.w[i]);
            } else if (targetOutput.w[i] == 0.0) {
                if (actualOutput.w[i] == 1.0) {
                    actualOutput.w[i] = 0.99999999;
                }
                sum += -Math.log(1.0 - actualOutput.w[i]);
            } else {
                throw new Exception("Invalid target");
            }
            ++i;
        }
        return sum;
    }
}

