/*
 * Decompiled with CFR 0.152.
 */
package loss;

import loss.Loss;
import matrix.Matrix;

public class LossCrossEntropy
implements Loss {
    @Override
    public void backward(Matrix actualOutput, Matrix targetOutput) throws Exception {
        int i = 0;
        while (i < targetOutput.w.length) {
            double d = actualOutput.w[i];
            if (d == 0.0) {
                d = 1.0E-8;
            }
            actualOutput.dw[i] = -targetOutput.w[i] / d;
            ++i;
        }
    }

    @Override
    public double measure(Matrix actualOutput, Matrix targetOutput) throws Exception {
        double sum = 0.0;
        int i = 0;
        while (i < targetOutput.w.length) {
            double d = actualOutput.w[i];
            if (d == 0.0) {
                d = 1.0E-8;
            }
            sum += targetOutput.w[i] * -Math.log(d);
            ++i;
        }
        return sum;
    }
}

