/*
 * Decompiled with CFR 0.152.
 */
package examples.deepRL;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CatchGame
extends JPanel
implements KeyListener,
Runnable {
    public JFrame frame;
    private boolean userInput = false;
    private int scale = 4;
    private int width = 84;
    private int height = 84;
    private int lives = 3;
    private Rectangle paddle;
    private Rectangle paddle2;
    private Rectangle ball;
    private boolean left = false;
    private boolean right = false;
    private double score;
    private int coughtBalls;
    private boolean gameOver = false;
    private BufferedImage image = null;
    private Graphics2D g = null;
    private Graphics g2 = null;
    private boolean paused = false;
    private Random random;
    private Thread t;
    private Color paddleColor = new Color(255, 255, 255);
    private Color ballColor = new Color(255, 255, 255);

    public CatchGame() {
        this.setPreferredSize(new Dimension(this.width * this.scale, this.height * this.scale));
    }

    public void init() {
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.random = new Random();
        this.lives = 3;
        this.score = 0.0;
        this.coughtBalls = 0;
        this.paused = false;
        this.gameOver = false;
        while (this.g2 == null) {
            this.g2 = this.getGraphics();
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.paddle = new Rectangle(this.random.nextInt(this.width - 16), this.height - 2, 16, 2);
        this.paddle2 = new Rectangle(10000, this.height - 2, 16, 2);
        this.ball = new Rectangle(this.random.nextInt(this.width - 2), 0, 3, 3);
        this.userInput = false;
        this.left = false;
        this.right = false;
        this.image = new BufferedImage(this.width, this.height, 1);
        this.g = (Graphics2D)this.image.getGraphics();
    }

    public void create() {
        this.frame = new JFrame("Catch");
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setContentPane(this);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        CatchGame f = new CatchGame();
        f.create();
        f.startGame();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f.setUseUserInput(true);
        System.out.println(f.isUsingUserInput());
    }

    public void destroy() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void startGame() {
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void run() {
        this.init();
        boolean running = true;
        long targetTime = 33333333L;
        long timer = System.nanoTime();
        long debugTimer = System.currentTimeMillis();
        int fps = 0;
        int extremum = 0;
        while (running) {
            if (System.nanoTime() - timer >= targetTime) {
                timer = System.nanoTime();
                this.renderNextFrame();
                ++fps;
            }
            if (this.gameOver) {
                running = false;
            }
            if (this.paddle.x > extremum) {
                extremum = this.paddle.x;
            }
            System.err.println(extremum);
            if (System.currentTimeMillis() - debugTimer >= 1000L) {
                debugTimer = System.currentTimeMillis();
                System.out.println("FPS: " + Integer.toString(fps));
                fps = 0;
            }
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void draw() {
        this.g.setColor(Color.BLACK);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(this.paddleColor);
        this.g.fillRect(this.paddle.x, this.paddle.y, this.paddle.width, this.paddle.height);
        if (this.paddle2.x != 10000) {
            this.g.fillRect(this.paddle2.x, this.paddle2.y, this.paddle2.width, this.paddle2.height);
        }
        this.g.setColor(this.ballColor);
        this.g.fillRect(this.ball.x, this.ball.y, this.ball.width, this.ball.height);
        this.g2.drawImage(this.paused ? CatchGame.grayscale(this.image) : this.image, 0, 0, this.width * this.scale, this.height * this.scale, this);
        this.g2.setColor(Color.WHITE);
        this.g2.drawString(Double.toString(this.score), 0, 10);
        this.g2.drawString(Integer.toString(this.lives), this.width * this.scale - 7, 10);
    }

    public BufferedImage testRender(Point ballPos, Point paddlePos, double score, int lives) {
        BufferedImage toReturn = new BufferedImage(this.width, this.height, 1);
        Graphics g = toReturn.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.paddleColor);
        g.fillRect(paddlePos.x, paddlePos.y, this.paddle.width, this.paddle.height);
        g.setColor(this.ballColor);
        g.fillRect(ballPos.x, ballPos.y, this.ball.width, this.ball.height);
        g.setColor(Color.WHITE);
        g.drawString(Double.toString(score), 0, 10);
        g.drawString(Integer.toString(lives), this.width - 7, 10);
        return toReturn;
    }

    public static BufferedImage grayscale(BufferedImage in) {
        BufferedImage toReturn = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        int i = 0;
        while (i < in.getWidth()) {
            int j = 0;
            while (j < in.getHeight()) {
                int gray;
                int argb = in.getRGB(i, j);
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                int rgb = gray = (int)((double)r / 3.0 + (double)g / 3.0 + (double)b / 3.0);
                rgb = (rgb << 8) + gray;
                rgb = (rgb << 8) + gray;
                toReturn.setRGB(i, j, rgb);
                ++j;
            }
            ++i;
        }
        return toReturn;
    }

    private void update() {
        if (this.left) {
            this.paddle.x -= 2;
        }
        if (this.right) {
            this.paddle.x += 2;
        }
        this.paddle2.x = this.paddle.x < 0 ? this.width + this.paddle.x : (this.paddle.x > this.width - this.paddle.width ? this.paddle.x - this.width : 10000);
        if (this.paddle2.x >= 0 && this.paddle2.x <= this.width - this.paddle.width) {
            this.paddle.x = this.paddle2.x;
            this.paddle2.x = 10000;
        }
        this.ball.y += 2;
        if (this.ball.intersects(this.paddle) || this.ball.intersects(this.paddle2)) {
            this.score += 1.0 + (double)this.coughtBalls / 32.0 * 4.0;
            ++this.coughtBalls;
            if (this.coughtBalls > 32) {
                this.coughtBalls = 32;
            }
            this.ball.y = 0;
            this.ball.x = this.random.nextInt(this.width - 2);
        }
        if (this.ball.y >= this.height) {
            this.score -= 1.0 + (double)this.coughtBalls / 32.0 * 4.0;
            --this.lives;
            this.ball.y = 0;
            this.ball.x = this.random.nextInt(this.width - 2);
        }
        if (this.lives <= 0) {
            this.gameOver = true;
        }
        this.frame.setTitle("Catch - Score: " + Double.toString(this.score));
    }

    public void setUseUserInput(boolean b) {
        this.userInput = b;
    }

    public boolean isUsingUserInput() {
        return this.userInput;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public double getScore() {
        return this.score;
    }

    public BufferedImage getCurrentFrame() {
        return this.image;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public void setRight(boolean right) {
        this.right = right;
    }

    public Point getBallPos() {
        return this.ball.getLocation();
    }

    public Point getPaddlePos() {
        return this.paddle.getLocation();
    }

    public void renderNextFrame() {
        if (!this.paused) {
            this.update();
        }
        this.draw();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 37 && this.userInput) {
            this.left = true;
        }
        if (e.getKeyCode() == 39 && this.userInput) {
            this.right = true;
        }
        if (e.getKeyCode() == 27 && this.userInput) {
            this.paused = !this.paused;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 37 && this.userInput) {
            this.left = false;
        }
        if (e.getKeyCode() == 39 && this.userInput) {
            this.right = false;
        }
    }
}

