/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.util.ArrayList;
import java.util.Random;
import loss.LossLogLoss;
import matrix.Tensor;
import model.NeuralNetwork;
import nonlinearities.Nonlinearity;
import nonlinearities.SigmoidUnit;
import util.CifarLoader;

public class CifarDataset
extends DataSet {
    public CifarDataset(CifarLoader loader, int imagesPerSequence, int sequenceCount, Random rng) {
        this.inputDimension = new DataSet.TensorDimensions(32, 32, 3);
        this.outputDimension = new DataSet.TensorDimensions(1, 10, 1);
        this.lossTraining = new LossLogLoss();
        this.lossReporting = new LossLogLoss();
        this.training = new ArrayList();
        this.training.add(new DataSequence());
        int i = 0;
        while (true) {
            int indx = rng.nextInt(loader.getImageCount());
            Tensor output = new Tensor(1, 10, 1);
            output.matrices[0].w[loader.getCategory((int)indx)] = 1.0;
            ((DataSequence)this.training.get(this.training.size() - 1)).addDataStep(new DataStep(CifarLoader.asTensor(loader.getImage(indx)), output));
            if (i % imagesPerSequence == 0 && i != 0) {
                if (this.training.size() == sequenceCount) break;
                this.training.add(new DataSequence());
            }
            ++i;
        }
    }

    @Override
    public void DisplayReport(NeuralNetwork model, Random rng) throws Exception {
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new SigmoidUnit();
    }
}

