/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.examples;

import com.leff.midi.MidiFile;
import com.leff.midi.MidiTrack;
import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.NoteOff;
import com.leff.midi.event.NoteOn;
import com.leff.midi.event.meta.Tempo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class MidiManipulation {
    public static void main(String[] args) {
        MidiFile mf = null;
        File input = new File("example.mid");
        try {
            mf = new MidiFile(input);
        }
        catch (IOException e) {
            System.err.println("Error parsing MIDI file:");
            e.printStackTrace();
            return;
        }
        MidiTrack T = mf.getTracks().get(1);
        Iterator<MidiEvent> it = T.getEvents().iterator();
        ArrayList<MidiEvent> eventsToRemove = new ArrayList<MidiEvent>();
        while (it.hasNext()) {
            MidiEvent E = it.next();
            if (E.getClass().equals(NoteOn.class) || E.getClass().equals(NoteOff.class)) continue;
            eventsToRemove.add(E);
        }
        for (MidiEvent E : eventsToRemove) {
            T.removeEvent(E);
        }
        mf.removeTrack(2);
        T = mf.getTracks().get(0);
        for (MidiEvent E : T.getEvents()) {
            if (!E.getClass().equals(Tempo.class)) continue;
            Tempo tempo = (Tempo)E;
            tempo.setBpm(tempo.getBpm() / 2.0f);
        }
        try {
            mf.writeToFile(input);
        }
        catch (IOException e) {
            System.err.println("Error writing MIDI file:");
            e.printStackTrace();
        }
    }
}

