/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.examples;

import com.leff.midi.MidiFile;
import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.NoteOn;
import com.leff.midi.event.meta.Tempo;
import com.leff.midi.util.MidiEventListener;
import com.leff.midi.util.MidiProcessor;
import java.io.File;
import java.io.IOException;

public class EventPrinter
implements MidiEventListener {
    private String mLabel;

    public EventPrinter(String label) {
        this.mLabel = label;
    }

    @Override
    public void onStart(boolean fromBeginning) {
        if (fromBeginning) {
            System.out.println(String.valueOf(this.mLabel) + " Started!");
        } else {
            System.out.println(String.valueOf(this.mLabel) + " resumed");
        }
    }

    @Override
    public void onEvent(MidiEvent event, long ms) {
        if (event.getTick() > 130320L && event.getTick() < 137280L) {
            System.out.println(String.valueOf(this.mLabel) + " received event: " + event);
        }
    }

    @Override
    public void onStop(boolean finished) {
        if (finished) {
            System.out.println(String.valueOf(this.mLabel) + " Finished!");
        } else {
            System.out.println(String.valueOf(this.mLabel) + " paused");
        }
    }

    public static void main(String[] args) {
        MidiFile midi = null;
        try {
            midi = new MidiFile(new File("midis/winter_wrap_up.mid"));
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
        MidiProcessor processor = new MidiProcessor(midi);
        EventPrinter ep = new EventPrinter("Individual Listener");
        processor.registerEventListener(ep, Tempo.class);
        processor.registerEventListener(ep, NoteOn.class);
        EventPrinter ep2 = new EventPrinter("Listener For All");
        processor.registerEventListener(ep2, MidiEvent.class);
        processor.start();
        try {
            Thread.sleep(10L);
            processor.stop();
            Thread.sleep(10L);
            processor.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

