/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event;

import com.leff.midi.event.ChannelEvent;

public class PitchBend
extends ChannelEvent {
    public PitchBend(long tick, int channel, int lsb, int msb) {
        super(tick, 14, channel, lsb, msb);
    }

    public PitchBend(long tick, long delta, int channel, int lsb, int msb) {
        super(tick, delta, 14, channel, lsb, msb);
    }

    public int getLeastSignificantBits() {
        return this.mValue1;
    }

    public int getMostSignificantBits() {
        return this.mValue2;
    }

    public int getBendAmount() {
        int y = (this.mValue2 & 0x7F) << 7;
        int x = this.mValue1;
        return y + x;
    }

    public void setLeastSignificantBits(int p) {
        this.mValue1 = p & 0x7F;
    }

    public void setMostSignificantBits(int p) {
        this.mValue2 = p & 0x7F;
    }

    public void setBendAmount(int amount) {
        this.mValue1 = (amount &= 0x3FFF) & 0x7F;
        this.mValue2 = amount >> 7;
    }
}

