/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ctif.platform;

import java.awt.Color;

public abstract class Platform {
    public final int platformId;
    private final int charWidth;
    private final int charHeight;
    private final int width;
    private final int height;
    private final int customColorCount;
    private Color[] palette = null;

    protected Platform(int platformId, int charWidth, int charHeight, int width, int height, int customColorCount) {
        this.platformId = platformId;
        this.charWidth = charWidth;
        this.charHeight = charHeight;
        this.width = width;
        this.height = height;
        this.customColorCount = customColorCount;
    }

    abstract Color[] generatePalette();

    public int getCharWidth() {
        return this.charWidth;
    }

    public int getCharHeight() {
        return this.charHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getChars() {
        return this.getWidth() * this.getHeight();
    }

    public int getCustomColorCount() {
        return this.customColorCount;
    }

    public Color[] getPalette() {
        if (this.palette == null) {
            this.palette = this.generatePalette();
        }
        return (Color[])this.palette.clone();
    }

    public float getDefaultAspectRatio() {
        return (float)this.getWidth() / (float)this.getHeight();
    }

    public final int getWidthPx() {
        return this.getWidth() * this.getCharWidth();
    }

    public final int getHeightPx() {
        return this.getHeight() * this.getCharHeight();
    }

    public final int getCharsPx() {
        return this.getChars() * this.getCharWidth() * this.getCharHeight();
    }
}

