/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ctif.colorspace;

import pl.asie.ctif.colorspace.Colorspace;

public class ColorspaceMatrix
extends Colorspace {
    private final Colorspace parent = null;
    private final float[] matrixFromRGB;
    private final float[] matrixToRGB;

    protected ColorspaceMatrix(float[] matrix) {
        this(null, matrix);
    }

    protected ColorspaceMatrix(Colorspace parent, float[] matrix) {
        this.matrixFromRGB = matrix;
        this.matrixToRGB = new float[9];
        float detInv = 1.0f / (matrix[0] * matrix[4] * matrix[8] + matrix[1] * matrix[5] * matrix[6] + matrix[2] * matrix[3] * matrix[7] - (matrix[2] * matrix[4] * matrix[6] + matrix[0] * matrix[5] * matrix[7] + matrix[1] * matrix[3] * matrix[8]));
        this.matrixToRGB[0] = detInv * (matrix[4] * matrix[8] - matrix[5] * matrix[7]);
        this.matrixToRGB[3] = -detInv * (matrix[3] * matrix[8] - matrix[5] * matrix[6]);
        this.matrixToRGB[6] = -detInv * (matrix[4] * matrix[6] - matrix[3] * matrix[7]);
        this.matrixToRGB[1] = -detInv * (matrix[1] * matrix[8] - matrix[2] * matrix[7]);
        this.matrixToRGB[4] = detInv * (matrix[0] * matrix[8] - matrix[2] * matrix[6]);
        this.matrixToRGB[7] = detInv * (matrix[1] * matrix[6] - matrix[0] * matrix[7]);
        this.matrixToRGB[2] = detInv * (matrix[1] * matrix[5] - matrix[2] * matrix[4]);
        this.matrixToRGB[5] = -detInv * (matrix[0] * matrix[5] - matrix[2] * matrix[3]);
        this.matrixToRGB[8] = -detInv * (matrix[1] * matrix[3] - matrix[0] * matrix[4]);
    }

    protected final float[] mmul3(float[] a, float[] b) {
        return new float[]{a[0] * b[0] + a[1] * b[1] + a[2] * b[2], a[0] * b[3] + a[1] * b[4] + a[2] * b[5], a[0] * b[6] + a[1] * b[7] + a[2] * b[8]};
    }

    @Override
    public float[] fromRGB(float[] value) {
        return this.mmul3(this.parent != null ? this.parent.fromRGB(value) : value, this.matrixFromRGB);
    }

    @Override
    public float[] toRGBArray(float[] value) {
        return this.parent != null ? this.parent.toRGBArray(this.mmul3(value, this.matrixToRGB)) : this.mmul3(value, this.matrixToRGB);
    }
}

