/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ctif.colorspace;

import pl.asie.ctif.colorspace.ColorspaceMatrix;

public abstract class Colorspace {
    public static final Colorspace YIQ;
    public static final Colorspace YUV;
    public static final Colorspace RGB;

    public int toRGB(float[] value) {
        float[] rgb = this.toRGBArray(value);
        if (rgb[0] < 0.0f) {
            rgb[0] = 0.0f;
        } else if (rgb[0] > 1.0f) {
            rgb[0] = 1.0f;
        }
        if (rgb[1] < 0.0f) {
            rgb[1] = 0.0f;
        } else if (rgb[1] > 1.0f) {
            rgb[1] = 1.0f;
        }
        if (rgb[2] < 0.0f) {
            rgb[2] = 0.0f;
        } else if (rgb[2] > 1.0f) {
            rgb[2] = 1.0f;
        }
        return Math.round(rgb[0] * 255.0f) << 16 | Math.round(rgb[1] * 255.0f) << 8 | Math.round(rgb[2] * 255.0f);
    }

    public float[] fromRGB(int value) {
        return this.fromRGB(new float[]{(float)(value >> 16 & 0xFF) / 255.0f, (float)(value >> 8 & 0xFF) / 255.0f, (float)(value & 0xFF) / 255.0f});
    }

    public abstract float[] fromRGB(float[] var1);

    public abstract float[] toRGBArray(float[] var1);

    static {
        YUV = new ColorspaceMatrix(new float[]{0.299f, 0.587f, 0.114f, -0.147f, -0.289f, 0.436f, 0.615f, -0.515f, -0.1f});
        YIQ = new ColorspaceMatrix(new float[]{0.299f, 0.587f, 0.114f, 0.595716f, -0.274453f, -0.321263f, 0.211456f, -0.522591f, 0.311135f});
        RGB = new Colorspace(){

            @Override
            public float[] fromRGB(float[] value) {
                return value;
            }

            @Override
            public float[] toRGBArray(float[] value) {
                return value;
            }
        };
    }
}

