/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ctif;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import pl.asie.ctif.Main;
import pl.asie.ctif.Utils;

public class PaletteGenerator {
    private final int colors;
    private final BufferedImage image;
    private final Color[] base;
    private final Random random = new Random();
    private final Map<Integer, float[]> pointsAdded = new HashMap<Integer, float[]>();
    private final Map<float[], Integer> pointsWeight = new HashMap<float[], Integer>();
    private final float[][] centroids;
    private final Map<float[], Double> knownBestError = new HashMap<float[], Double>();
    private final Map<float[], Integer> knownBestCentroid = new HashMap<float[], Integer>();

    public PaletteGenerator(BufferedImage image, Color[] base, int colors) {
        this.colors = colors;
        this.image = image;
        this.base = base;
        this.centroids = new float[base.length][];
        for (int i : Utils.getRGB(image)) {
            if (!this.pointsAdded.containsKey(i)) {
                float[] key = Main.COLORSPACE.fromRGB(i);
                this.pointsAdded.put(i, key);
                this.pointsWeight.put(key, 1);
                continue;
            }
            this.pointsWeight.put(this.pointsAdded.get(i), this.pointsWeight.get(this.pointsAdded.get(i)) + 1);
        }
        for (int i = colors; i < this.centroids.length; ++i) {
            this.centroids[i] = Main.COLORSPACE.fromRGB(base[i].getRGB());
        }
        for (Map.Entry<float[], Integer> weight : this.pointsWeight.entrySet()) {
            double bestError = 3.4028234663852886E38;
            int bestCentroid = 0;
            for (int i = colors; i < this.centroids.length; ++i) {
                double err = Utils.getColorDistanceSq(weight.getKey(), this.centroids[i]);
                if (!(err < bestError)) continue;
                bestError = err;
                bestCentroid = i;
                if (err == 0.0) break;
            }
            this.knownBestError.put(weight.getKey(), bestError);
            this.knownBestCentroid.put(weight.getKey(), bestCentroid);
        }
    }

    public Color[] generate(int threads) {
        Result bestResult = null;
        Worker[] workers = new Worker[20 / (Main.OPTIMIZATION_LEVEL + 1)];
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new Worker();
            executorService.submit(workers[i]);
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < workers.length; ++i) {
            Result result = workers[i].result;
            if (Main.DEBUG) {
                System.out.println("Palette generator worker #" + (i + 1) + " error = " + result.error);
            }
            if (bestResult != null && !(bestResult.error > result.error)) continue;
            bestResult = result;
        }
        if (Main.DEBUG) {
            System.out.println("Palette generator error = " + bestResult.error);
        }
        return bestResult.colors;
    }

    private Result generateKMeans() {
        for (int i = 0; i < this.colors; ++i) {
            this.centroids[i] = Main.COLORSPACE.fromRGB(this.image.getRGB(this.random.nextInt(this.image.getWidth()), this.random.nextInt(this.image.getHeight())));
        }
        double totalError = 0.0;
        for (int reps = 0; reps < 128; ++reps) {
            float[][] means = new float[this.centroids.length][3];
            int[] meanDivs = new int[this.centroids.length];
            totalError = 0.0;
            for (Map.Entry<float[], Integer> weight : this.pointsWeight.entrySet()) {
                double bestError = this.knownBestError.get(weight.getKey());
                int bestCentroid = this.knownBestCentroid.get(weight.getKey());
                int mul = weight.getValue();
                for (int i = 0; i < this.colors; ++i) {
                    double err = Utils.getColorDistanceSq(weight.getKey(), this.centroids[i]);
                    if (!(err < bestError)) continue;
                    bestError = err;
                    bestCentroid = i;
                    if (err == 0.0) break;
                }
                totalError += bestError * (double)mul;
                float[] fArray = means[bestCentroid];
                fArray[0] = fArray[0] + weight.getKey()[0] * (float)mul;
                float[] fArray2 = means[bestCentroid];
                fArray2[1] = fArray2[1] + weight.getKey()[1] * (float)mul;
                float[] fArray3 = means[bestCentroid];
                fArray3[2] = fArray3[2] + weight.getKey()[2] * (float)mul;
                int n = bestCentroid;
                meanDivs[n] = meanDivs[n] + mul;
            }
            boolean changed = false;
            for (int i = 0; i < this.colors; ++i) {
                if (meanDivs[i] <= 0) continue;
                float n0 = means[i][0] / (float)meanDivs[i];
                float n1 = means[i][1] / (float)meanDivs[i];
                float n2 = means[i][2] / (float)meanDivs[i];
                if (n0 == this.centroids[i][0] && n1 == this.centroids[i][1] && n2 == this.centroids[i][2]) continue;
                this.centroids[i][0] = n0;
                this.centroids[i][1] = n1;
                this.centroids[i][2] = n2;
                changed = true;
            }
            if (!changed) break;
        }
        Color[] out = Arrays.copyOf(this.base, this.base.length);
        for (int k = 0; k < this.colors; ++k) {
            out[k] = new Color(Main.COLORSPACE.toRGB(this.centroids[k]) | 0xFF000000);
        }
        return new Result(out, totalError);
    }

    public class Worker
    implements Runnable {
        public Result result;

        @Override
        public void run() {
            this.result = PaletteGenerator.this.generateKMeans();
        }
    }

    static class Result {
        final Color[] colors;
        final double error;

        public Result(Color[] colors, double error) {
            this.colors = colors;
            this.error = error;
        }
    }
}

