/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ctif;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.asie.ctif.Converter;
import pl.asie.ctif.PaletteGenerator;
import pl.asie.ctif.Utils;
import pl.asie.ctif.colorspace.Colorspace;
import pl.asie.ctif.platform.Platform;
import pl.asie.ctif.platform.PlatformComputerCraft;
import pl.asie.ctif.platform.PlatformOpenComputers;
import pl.asie.ctif.platform.PlatformZXSpectrum;

public class Main {
    public static Colorspace COLORSPACE;
    public static Platform PLATFORM;
    public static int OPTIMIZATION_LEVEL;
    private static final Map<String, float[]> DITHER_ARRAYS;
    private static final Map<String, Platform> PLATFORMS;
    private static final Map<String, Colorspace> COLORSPACES;
    public static boolean DEBUG;
    private static Parameters params;

    private static int rCeil(int x, int y) {
        if (x % y > 0) {
            return x - x % y + y;
        }
        return x;
    }

    public static void main(String[] args) {
        BufferedImage resizedImage;
        BufferedImage image;
        params = new Parameters();
        JCommander jCommander = new JCommander((Object)params, args);
        if (params.help) {
            jCommander.usage();
            System.exit(0);
        }
        PLATFORM = PLATFORMS.get(params.mode.toLowerCase());
        COLORSPACE = COLORSPACES.get(params.colorspace.toLowerCase());
        if (params.files.size() == 0) {
            System.err.println("No input file specified!");
            System.exit(1);
        }
        if (PLATFORM == null) {
            System.err.println(String.format("Invalid mode: %s", params.mode));
            System.exit(1);
        }
        OPTIMIZATION_LEVEL = params.optimizationLevel;
        DEBUG = params.debug;
        if (params.ditherType == null) {
            switch (params.ditherMode) {
                case ORDERED: {
                    params.ditherType = "4x4";
                    break;
                }
                default: {
                    params.ditherType = "floyd-steinberg";
                }
            }
        }
        if ((image = Utils.loadImage((String)params.files.get(0))) == null) {
            System.err.println(String.format("Could not load image: %s", params.files.get(0)));
            System.exit(1);
        }
        Color[] palette = PLATFORM.getPalette();
        params.w = params.w > 0 ? Main.rCeil(params.w, Main.PLATFORM.getCharWidth()) : 0;
        params.h = params.h > 0 ? Main.rCeil(params.h, Main.PLATFORM.getCharHeight()) : 0;
        if (params.w > 0 && params.h == 0) {
            params.h = params.w * image.getHeight() / image.getWidth();
        } else if (params.w == 0 && params.h > 0) {
            params.w = params.h * image.getWidth() / image.getHeight();
        }
        if (params.w * params.h > PLATFORM.getCharsPx()) {
            System.err.println(String.format("Size too large: %dx%d (maximum size: %d pixels)", params.w, params.h, PLATFORM.getCharsPx()));
            System.exit(1);
        } else if (params.w > PLATFORM.getWidthPx()) {
            System.err.println(String.format("Width too large: %d (maximum width: %d)", params.w, PLATFORM.getWidthPx()));
            System.exit(1);
        } else if (params.h > PLATFORM.getHeightPx()) {
            System.err.println(String.format("Height too large: %d (maximum height: %d)", params.h, PLATFORM.getHeightPx()));
            System.exit(1);
        }
        if (params.w == 0 || params.h == 0) {
            float x = params.ignoreAspectRatio ? PLATFORM.getDefaultAspectRatio() : (float)image.getWidth() / (float)image.getHeight();
            float y = 1.0f;
            float a = Math.min(Math.min((float)PLATFORM.getWidthPx() / x, (float)PLATFORM.getHeightPx() / y), (float)Math.sqrt((float)PLATFORM.getCharsPx() / (x * y)));
            params.w = Main.rCeil((int)Math.floor(x * a), Main.PLATFORM.getCharWidth());
            params.h = Main.rCeil((int)Math.floor(y * a), Main.PLATFORM.getCharHeight());
        }
        int width = params.w;
        int height = params.h;
        if (DEBUG) {
            System.err.println("Using " + params.threads + " threads.");
        }
        BufferedImage bufferedImage = resizedImage = image.getWidth() == width && image.getHeight() == height ? image : Utils.resize(image, width, height);
        if (PLATFORM.getCustomColorCount() > 0) {
            long time = System.currentTimeMillis();
            System.err.println("Generating palette...");
            PaletteGenerator generator = new PaletteGenerator(resizedImage, palette, PLATFORM.getCustomColorCount());
            palette = generator.generate(params.threads);
            time = System.currentTimeMillis() - time;
            if (DEBUG) {
                System.err.println("Palette generation time: " + time + " ms");
            }
        }
        try {
            BufferedImage outputImage = resizedImage;
            float[] ditherArray = DITHER_ARRAYS.get(params.ditherType.toLowerCase());
            if (params.ditherLevel == 0.0f) {
                params.ditherMode = Converter.DitherMode.NONE;
            } else if (params.ditherLevel != 1.0f) {
                ditherArray = Arrays.copyOf(ditherArray, ditherArray.length);
                switch (params.ditherMode) {
                    case ERROR: {
                        int i = 0;
                        while (i < ditherArray.length) {
                            int n = i++;
                            ditherArray[n] = ditherArray[n] * params.ditherLevel;
                        }
                        break;
                    }
                    case ORDERED: {
                        float newScale = params.ditherLevel;
                        float newOffset = (float)ditherArray.length * ((1.0f - params.ditherLevel) / 2.0f);
                        for (int i = 0; i < ditherArray.length; ++i) {
                            if (!(ditherArray[i] > 0.0f)) continue;
                            ditherArray[i] = (ditherArray[i] - 1.0f) * newScale + newOffset;
                        }
                        break;
                    }
                }
            }
            System.err.println("Converting image...");
            long time = System.currentTimeMillis();
            Converter writer = new Converter(palette, resizedImage, params.ditherMode, ditherArray);
            try {
                outputImage = writer.write(new FileOutputStream(params.outputFilename != null ? params.outputFilename : (String)params.files.get(0) + ".ctif"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            time = System.currentTimeMillis() - time;
            if (DEBUG) {
                System.err.println("Image conversion time: " + time + " ms");
            }
            if (params.previewFilename != null) {
                Utils.saveImage(Utils.resizeBox(outputImage, width * 2, height * 2), new File(params.previewFilename).getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        int i;
        COLORSPACE = null;
        PLATFORM = null;
        OPTIMIZATION_LEVEL = 1;
        DITHER_ARRAYS = new HashMap<String, float[]>();
        PLATFORMS = new HashMap<String, Platform>();
        COLORSPACES = new HashMap<String, Colorspace>();
        PLATFORMS.put("cc", new PlatformComputerCraft(false));
        PLATFORMS.put("cc-paletted", new PlatformComputerCraft(true));
        PLATFORMS.put("oc-tier2", new PlatformOpenComputers(2));
        PLATFORMS.put("oc-tier3", new PlatformOpenComputers(3));
        PLATFORMS.put("zxspectrum", new PlatformZXSpectrum(0));
        PLATFORMS.put("zxspectrum-dark", new PlatformZXSpectrum(1));
        COLORSPACES.put("rgb", Colorspace.RGB);
        COLORSPACES.put("yuv", Colorspace.YUV);
        COLORSPACES.put("yiq", Colorspace.YIQ);
        DITHER_ARRAYS.put("floyd-steinberg", new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4375f, 0.1875f, 0.3125f, 0.0625f});
        DITHER_ARRAYS.put("sierra-lite", new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.25f, 0.25f, 0.0f});
        DITHER_ARRAYS.put("checks", new float[]{0.0f, 1.0f, 1.0f, 0.0f, 2.0f});
        DITHER_ARRAYS.put("2x2", new float[]{0.0f, 2.0f, 3.0f, 1.0f, 4.0f});
        DITHER_ARRAYS.put("3x3", new float[]{0.0f, 7.0f, 3.0f, 6.0f, 5.0f, 2.0f, 4.0f, 1.0f, 8.0f, 9.0f});
        DITHER_ARRAYS.put("4x4", new float[]{0.0f, 8.0f, 2.0f, 10.0f, 12.0f, 4.0f, 14.0f, 6.0f, 3.0f, 11.0f, 1.0f, 9.0f, 15.0f, 7.0f, 13.0f, 5.0f, 16.0f});
        DITHER_ARRAYS.put("8x8", new float[]{0.0f, 48.0f, 12.0f, 60.0f, 3.0f, 51.0f, 15.0f, 63.0f, 32.0f, 16.0f, 44.0f, 28.0f, 35.0f, 19.0f, 47.0f, 31.0f, 8.0f, 56.0f, 4.0f, 52.0f, 11.0f, 59.0f, 7.0f, 55.0f, 40.0f, 24.0f, 36.0f, 20.0f, 43.0f, 27.0f, 39.0f, 23.0f, 2.0f, 50.0f, 14.0f, 62.0f, 1.0f, 49.0f, 13.0f, 61.0f, 34.0f, 18.0f, 46.0f, 30.0f, 33.0f, 17.0f, 45.0f, 29.0f, 10.0f, 58.0f, 6.0f, 54.0f, 9.0f, 57.0f, 5.0f, 53.0f, 42.0f, 26.0f, 38.0f, 22.0f, 41.0f, 25.0f, 37.0f, 21.0f, 64.0f});
        for (i = 3; i <= 8; ++i) {
            float[] arrL = new float[i * i + 1];
            float[] arrR = new float[i * i + 1];
            float[] arrS = new float[i * i + 1];
            float f = i;
            arrR[i * i] = f;
            arrL[i * i] = f;
            arrS[i * i] = i * i;
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < i; ++k) {
                    arrL[k * i + j] = (i - 1 - j + (i - k)) % i;
                    arrR[k * i + j] = (j + (i - k)) % i;
                    arrS[k * i + j] = Math.max(k, j) * Math.max(k, j);
                }
            }
            DITHER_ARRAYS.put("diag-l-" + i + "x" + i, arrL);
            DITHER_ARRAYS.put("diag-r-" + i + "x" + i, arrR);
            DITHER_ARRAYS.put("square-" + i + "x" + i, arrS);
        }
        for (i = 3; i <= 8; i += 2) {
            float[] arrD = new float[i * i + 1];
            arrD[i * i] = i * i;
            int center = i / 2;
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < i; ++k) {
                    arrD[k * i + j] = Math.abs(j - center) + Math.abs(k - center);
                    int n = k * i + j;
                    arrD[n] = arrD[n] * arrD[k * i + j];
                }
            }
            DITHER_ARRAYS.put("diamond-" + i + "x" + i, arrD);
        }
        DITHER_ARRAYS.put("diagl-4x4", new float[]{3.0f, 2.0f, 1.0f, 0.0f, 2.0f, 1.0f, 0.0f, 3.0f, 1.0f, 0.0f, 3.0f, 2.0f, 0.0f, 3.0f, 2.0f, 1.0f, 4.0f});
        DITHER_ARRAYS.put("diagr-4x4", new float[]{0.0f, 1.0f, 2.0f, 3.0f, 3.0f, 0.0f, 1.0f, 2.0f, 2.0f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f, 3.0f, 0.0f, 4.0f});
        DEBUG = false;
    }

    private static class Parameters {
        @Parameter(names={"--threads"}, description="Amount of threads to create")
        private int threads = Runtime.getRuntime().availableProcessors();
        @Parameter(names={"-m", "--mode"}, description="Target platform (cc, cc-paletted, oc-tier2, oc-tier3)")
        private String mode = "oc-tier3";
        @Parameter(names={"-O", "--optimization-level"}, description="Optimization level [primarily 0-4]. Larger levels = less accurate but faster generated images. Default is 1.")
        private int optimizationLevel = 1;
        @Parameter(names={"--colorspace"}, description="Colorspace (rgb, yuv, yiq)")
        private String colorspace = "yiq";
        @Parameter(names={"--dither-mode"}, description="Dither mode (none, error, ordered)")
        private Converter.DitherMode ditherMode = Converter.DitherMode.ERROR;
        @Parameter(names={"--dither-type"}, description="Dither type (error: floyd-steinberg, sierra-lite; ordered: 2x2, 4x4, 8x8)")
        private String ditherType;
        @Parameter(names={"--dither-level"}, description="Dither level for error-type dither. 0 = off, 1 = full (default)")
        private float ditherLevel = 1.0f;
        @Parameter(names={"-d", "--debug"}, description="Enable debugging", hidden=true)
        private boolean debug = false;
        @Parameter(names={"-W", "--width"}, description="Output image width")
        private int w;
        @Parameter(names={"-H", "--height"}, description="Output image height")
        private int h;
        @Parameter(names={"-N", "--no-aspect"}, description="Ignore aspect ratio")
        private boolean ignoreAspectRatio = false;
        @Parameter(names={"-o", "--output"}, description="Output filename")
        private String outputFilename;
        @Parameter(names={"-P", "--preview"}, description="Preview image filename")
        private String previewFilename;
        @Parameter(description="Input file")
        private List<String> files = new ArrayList<String>();
        @Parameter(names={"-h", "--help"}, description="Print usage", help=true)
        private boolean help;

        private Parameters() {
        }
    }
}

