/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ctif;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import pl.asie.ctif.Main;
import pl.asie.ctif.Utils;
import pl.asie.ctif.platform.PlatformComputerCraft;
import pl.asie.ctif.platform.PlatformOpenComputers;
import pl.asie.ctif.platform.PlatformZXSpectrum;

public class Converter {
    private final Color[] palette;
    private final BufferedImage image;
    private final DitherMode ditherMode;
    private final float[] ditherMatrix;
    private final int ditherMatrixSize;
    private final int ditherMatrixOffset;
    private final float[][] img;
    private final float[][] pal;
    private final int cw;
    private final int ch;
    private final int pw;
    private final int ph;
    private final int ditherMax;

    public Converter(Color[] colors, BufferedImage image, DitherMode ditherMode, float[] ditherMatrix) {
        int i = 0;
        this.ditherMode = ditherMode;
        this.ditherMatrix = ditherMatrix;
        if (ditherMode == DitherMode.ORDERED) {
            assert (ditherMatrix != null);
            this.ditherMatrixSize = (int)Math.sqrt(ditherMatrix.length - 1);
            this.ditherMatrixOffset = 0;
            this.ditherMax = (int)ditherMatrix[ditherMatrix.length - 1];
        } else {
            this.ditherMatrixSize = ditherMatrix != null ? (int)Math.sqrt(ditherMatrix.length) : 0;
            this.ditherMatrixOffset = (this.ditherMatrixSize - 1) / 2;
            this.ditherMax = 0;
        }
        this.image = image;
        this.palette = colors;
        this.img = new float[image.getWidth() * image.getHeight()][3];
        this.pal = new float[colors.length][3];
        this.pw = Main.PLATFORM.getCharWidth();
        this.ph = Main.PLATFORM.getCharHeight();
        this.cw = image.getWidth() / this.pw;
        this.ch = image.getHeight() / this.ph;
        for (i = 0; i < this.img.length; ++i) {
            this.img[i] = Main.COLORSPACE.fromRGB(image.getRGB(i % image.getWidth(), i / image.getWidth()));
        }
        for (i = 0; i < colors.length; ++i) {
            this.pal[i] = Main.COLORSPACE.fromRGB(colors[i].getRGB());
        }
    }

    public BufferedImage write(OutputStream stream) throws IOException {
        BufferedImage output = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 5);
        stream.write(67);
        stream.write(84);
        stream.write(73);
        stream.write(70);
        stream.write(1);
        stream.write(0);
        stream.write(Main.PLATFORM.platformId);
        stream.write(Main.PLATFORM.platformId >> 8);
        stream.write(this.cw & 0xFF);
        stream.write(this.cw >> 8);
        stream.write(this.ch & 0xFF);
        stream.write(this.ch >> 8);
        stream.write(this.pw);
        stream.write(this.ph);
        stream.write(this.palette.length > 16 ? 8 : 4);
        if (Main.PLATFORM.getCustomColorCount() > 0) {
            stream.write(3);
            stream.write(16);
            stream.write(0);
            for (int i = 0; i < 16; ++i) {
                stream.write(this.palette[i].getRGB() & 0xFF);
                stream.write(this.palette[i].getRGB() >> 8 & 0xFF);
                stream.write(this.palette[i].getRGB() >> 16 & 0xFF);
            }
        } else {
            stream.write(0);
            stream.write(0);
            stream.write(0);
        }
        this.writePixelData(stream, output);
        stream.close();
        return output;
    }

    private void addQuantError(float[][] pixelArray, int x, int y, int w, int h, float[] expected, float[] received, float mul) {
        if (x >= 0 && y >= 0 && x < w && y < h) {
            Utils.addQuantError(pixelArray[y * w + x], expected, received, mul);
        }
    }

    private void writePixelData(OutputStream stream, BufferedImage output) throws IOException {
        int t3OffRed;
        int ew = this.pw + this.ditherMatrixOffset * 2;
        int eh = this.ph + this.ditherMatrixOffset * 2;
        int quadrantLen = (this.pw * this.ph + 7) / 8;
        float[][] pixels = new float[this.pw * this.ph][];
        float[][] bcea = new float[ew * eh][3];
        float[][] tPixels = new float[pixels.length][3];
        float[][] errors = new float[ew * eh][3];
        int[] bcq = new int[quadrantLen];
        int[] cq = new int[quadrantLen];
        float[] colA = new float[3];
        boolean usePalMap = Main.OPTIMIZATION_LEVEL > 0 && Main.PLATFORM instanceof PlatformOpenComputers && ((PlatformOpenComputers)Main.PLATFORM).tier == 3;
        int[] palMap = new int[this.palette.length];
        for (int i = 0; i < 16; ++i) {
            palMap[i] = i;
        }
        int n = Main.OPTIMIZATION_LEVEL <= 1 ? 3 : (t3OffRed = Main.OPTIMIZATION_LEVEL == 2 ? 2 : 1);
        int t3OffGreen = Main.OPTIMIZATION_LEVEL <= 1 ? 3 : (Main.OPTIMIZATION_LEVEL <= 3 ? 2 : 1);
        int t3OffBlue = Main.OPTIMIZATION_LEVEL <= 1 ? 2 : 1;
        for (int cy = 0; cy < this.ch; ++cy) {
            for (int cx = 0; cx < this.cw; ++cx) {
                int t;
                int i;
                int palMapLength;
                for (int py = 0; py < this.ph; ++py) {
                    for (int px = 0; px < this.pw; ++px) {
                        pixels[py * this.pw + px] = this.img[(cy * this.ph + py) * this.image.getWidth() + cx * this.pw + px];
                    }
                }
                int bci1 = 0;
                int bci2 = 0;
                double bcerr = Double.MAX_VALUE;
                if (usePalMap) {
                    palMapLength = 16;
                    int[] colorsUsed = new int[this.palette.length];
                    for (int py = 0; py < this.ph; ++py) {
                        for (int px = 0; px < this.pw; ++px) {
                            int rgb = this.image.getRGB(cx * this.pw + px, cy * this.ph + py);
                            int red = (rgb >> 16 & 0xFF) * 6 / 256;
                            int green = (rgb >> 8 & 0xFF) * 8 / 256;
                            int blue = (rgb & 0xFF) * 5 / 256;
                            for (int rr = red - t3OffRed; rr <= red + t3OffRed; ++rr) {
                                for (int rg = green - t3OffGreen; rg <= green + t3OffGreen; ++rg) {
                                    for (int rb = blue - t3OffBlue; rb <= blue + t3OffBlue; ++rb) {
                                        int col;
                                        if (rr < 0 || rg < 0 || rb < 0 || rr >= 6 || rg >= 8 || rb >= 5 || colorsUsed[col = 16 + rr * 40 + rg * 5 + rb] != 0) continue;
                                        palMap[palMapLength++] = col;
                                        colorsUsed[col] = 1;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    palMapLength = this.palette.length;
                }
                for (int cim1 = 1; cim1 < palMapLength && bcerr != 0.0; ++cim1) {
                    int cim2;
                    int ci1 = usePalMap ? palMap[cim1] : cim1;
                    float[] col1 = this.pal[ci1];
                    int n2 = Main.PLATFORM instanceof PlatformZXSpectrum ? (cim1 >= 8 ? 8 : 0) : (cim2 = 0);
                    while (cim2 < cim1 && bcerr != 0.0) {
                        int pos;
                        float[] col;
                        int i2;
                        int ci2 = usePalMap ? palMap[cim2] : cim2;
                        float[] col2 = this.pal[ci2];
                        double cerr = 0.0;
                        for (i2 = 0; i2 < quadrantLen; ++i2) {
                            cq[i2] = 0;
                        }
                        if (this.ditherMode == DitherMode.NONE) {
                            for (i2 = 0; i2 < pixels.length; ++i2) {
                                col = pixels[i2];
                                double cerr1 = Utils.getColorDistanceSq(col, col1);
                                double cerr2 = Utils.getColorDistanceSq(col, col2);
                                if (cerr2 < cerr1) {
                                    int pos2 = this.pw * this.ph - 1 - i2;
                                    int n3 = pos2 >> 3;
                                    cq[n3] = cq[n3] | 1 << (pos2 & 7);
                                    cerr += cerr2;
                                } else {
                                    cerr += cerr1;
                                }
                                if (!(cerr >= bcerr)) {
                                    continue;
                                }
                                break;
                            }
                        } else if (this.ditherMode == DitherMode.ERROR) {
                            for (i2 = 0; i2 < pixels.length; ++i2) {
                                tPixels[i2][0] = pixels[i2][0];
                                tPixels[i2][1] = pixels[i2][1];
                                tPixels[i2][2] = pixels[i2][2];
                            }
                            for (i2 = 0; i2 < errors.length; ++i2) {
                                errors[i2][0] = 0.0f;
                                errors[i2][1] = 0.0f;
                                errors[i2][2] = 0.0f;
                            }
                            for (i2 = 0; i2 < tPixels.length; ++i2) {
                                float[] colR;
                                col = tPixels[i2];
                                double cerr1 = Utils.getColorDistanceSq(col, col1);
                                double cerr2 = Utils.getColorDistanceSq(col, col2);
                                if (cerr2 < cerr1) {
                                    pos = this.pw * this.ph - 1 - i2;
                                    int n4 = pos >> 3;
                                    cq[n4] = cq[n4] | 1 << (pos & 7);
                                    cerr += cerr2;
                                    colR = col2;
                                } else {
                                    cerr += cerr1;
                                    colR = col1;
                                }
                                if (!(cerr >= bcerr)) {
                                    int qx = i2 % this.pw;
                                    int qy = i2 / this.pw;
                                    int ip = this.ditherMatrixSize * this.ditherMatrixOffset;
                                    for (int iy = 0; iy < this.ditherMatrixSize - this.ditherMatrixOffset; ++iy) {
                                        for (int ix = -this.ditherMatrixOffset; ix < this.ditherMatrixSize - this.ditherMatrixOffset; ++ix) {
                                            this.addQuantError(tPixels, qx + ix, qy + iy, this.pw, this.ph, col, colR, this.ditherMatrix[ip]);
                                            this.addQuantError(errors, qx + ix + this.ditherMatrixOffset, qy + iy + this.ditherMatrixOffset, ew, eh, col, colR, this.ditherMatrix[ip]);
                                            ++ip;
                                        }
                                    }
                                    continue;
                                }
                                break;
                            }
                        } else {
                            cerr += Utils.getColorDistanceSq(col1, col2) * 0.1 * (double)pixels.length;
                            for (i2 = 0; i2 < pixels.length; ++i2) {
                                col = pixels[i2];
                                int qx = i2 % this.pw;
                                int qy = i2 / this.pw;
                                float jf = (col[0] * col1[0] - col[0] * col2[0] - col1[0] * col2[0] + col2[0] * col2[0] + col[1] * col1[1] - col[1] * col2[1] - col1[1] * col2[1] + col2[1] * col2[1] + col[2] * col1[2] - col[2] * col2[2] - col1[2] * col2[2] + col2[2] * col2[2]) / ((col1[0] - col2[0]) * (col1[0] - col2[0]) + (col1[1] - col2[1]) * (col1[1] - col2[1]) + (col1[2] - col2[2]) * (col1[2] - col2[2]));
                                int birat = this.ditherMax - Math.round(jf * (float)this.ditherMax);
                                if (birat < 0) {
                                    birat = 0;
                                } else if (birat > this.ditherMax) {
                                    birat = this.ditherMax;
                                }
                                colA[0] = (col2[0] * (float)birat + col1[0] * (float)(this.ditherMax - birat)) / (float)this.ditherMax;
                                colA[1] = (col2[1] * (float)birat + col1[1] * (float)(this.ditherMax - birat)) / (float)this.ditherMax;
                                colA[2] = (col2[2] * (float)birat + col1[2] * (float)(this.ditherMax - birat)) / (float)this.ditherMax;
                                if (!((cerr += Utils.getColorDistanceSq(col, colA)) >= bcerr)) {
                                    int threshold = (int)this.ditherMatrix[(cy * this.ph + qy) % this.ditherMatrixSize * this.ditherMatrixSize + (cx * this.pw + qx) % this.ditherMatrixSize];
                                    if (threshold >= birat) continue;
                                    pos = this.pw * this.ph - 1 - i2;
                                    int n5 = pos >> 3;
                                    cq[n5] = cq[n5] | 1 << (pos & 7);
                                    continue;
                                }
                                break;
                            }
                        }
                        if (cerr < bcerr) {
                            bci1 = ci1;
                            bci2 = ci2;
                            bcerr = cerr;
                            if (this.ditherMode == DitherMode.ERROR) {
                                for (i2 = 0; i2 < errors.length; ++i2) {
                                    bcea[i2][0] = errors[i2][0];
                                    bcea[i2][1] = errors[i2][1];
                                    bcea[i2][2] = errors[i2][2];
                                }
                            }
                            for (i2 = 0; i2 < quadrantLen; ++i2) {
                                bcq[i2] = cq[i2];
                            }
                        }
                        ++cim2;
                    }
                }
                if (this.ditherMode == DitherMode.ERROR) {
                    for (int iy = 0; iy < eh; ++iy) {
                        int ry = cy * this.ph + iy - this.ditherMatrixOffset;
                        if (ry < 0 || ry >= this.ch * this.ph) continue;
                        for (int ix = 0; ix < ew; ++ix) {
                            int rx = cx * this.pw + ix - this.ditherMatrixOffset;
                            if (rx < 0 || rx >= this.cw * this.pw) continue;
                            for (int i3 = 0; i3 < 3; ++i3) {
                                float[] fArray = this.img[ry * this.cw * this.pw + rx];
                                int n6 = i3;
                                fArray[n6] = fArray[n6] + bcea[iy * ew + ix][i3];
                            }
                        }
                    }
                }
                int[] quadrant = bcq;
                int bgIndex = bci1;
                int fgIndex = bci2;
                if (bgIndex == fgIndex) {
                    for (i = 0; i < quadrantLen; ++i) {
                        quadrant[i] = 0;
                    }
                }
                if (Main.PLATFORM instanceof PlatformComputerCraft) {
                    if ((quadrant[0] & 1) != 0) {
                        t = fgIndex;
                        fgIndex = bgIndex;
                        bgIndex = t;
                        quadrant[0] = quadrant[0] ^ 0x3F;
                    }
                } else if (Main.PLATFORM instanceof PlatformOpenComputers && this.pw * this.ph > 2 && bgIndex > fgIndex) {
                    t = fgIndex;
                    fgIndex = bgIndex;
                    bgIndex = t;
                    quadrant[0] = quadrant[0] ^ (1 << this.pw * this.ph) - 1;
                }
                if (this.pw * this.ph == 2 && quadrant[0] == 1) {
                    t = fgIndex;
                    fgIndex = bgIndex;
                    bgIndex = t;
                    quadrant[0] = 0;
                }
                if (this.palette.length > 2) {
                    if (this.pw * this.ph == 1) {
                        stream.write(fgIndex);
                    } else if (this.palette.length > 16) {
                        stream.write(bgIndex);
                        stream.write(fgIndex);
                    } else {
                        stream.write(bgIndex << 4 | fgIndex);
                    }
                    if (this.pw * this.ph > 2) {
                        for (i = 0; i < quadrantLen; ++i) {
                            stream.write(quadrant[i]);
                        }
                    }
                } else {
                    for (i = 0; i < quadrantLen; ++i) {
                        stream.write(quadrant[i]);
                    }
                }
                for (int py = 0; py < this.ph; ++py) {
                    for (int px = 0; px < this.pw; ++px) {
                        int i4 = this.pw * this.ph - 1 - (py * this.pw + px);
                        if ((quadrant[i4 >> 3] & 1 << (i4 & 7)) != 0) {
                            output.setRGB(cx * this.pw + px, cy * this.ph + py, this.palette[fgIndex].getRGB());
                            continue;
                        }
                        output.setRGB(cx * this.pw + px, cy * this.ph + py, this.palette[bgIndex].getRGB());
                    }
                }
            }
        }
    }

    public static enum DitherMode {
        NONE,
        ERROR,
        ORDERED;

    }
}

