/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.shaders;

import org.joml.Matrix4f;
import theGhastModding.weightDisplay.resources.Camera;
import theGhastModding.weightDisplay.shaders.ShaderProgram;
import theGhastModding.weightDisplay.utils.Maths;

public class WeightShader
extends ShaderProgram {
    private static final String VERTEX_FILE = "/theGhastModding/weightDisplay/shaders/vertexShader.txt";
    private static final String FRAGMENT_FILE = "/theGhastModding/weightDisplay/shaders/fragmentShader.txt";
    private int location_projectionMatrix;
    private int location_viewMatrix;
    private int location_transformationMatrix;

    public WeightShader() throws Exception {
        super(VERTEX_FILE, FRAGMENT_FILE);
    }

    @Override
    protected void bindAttributes() {
        super.bindAttribute(0, "position");
        super.bindAttribute(1, "val");
    }

    @Override
    protected void getAllUniformLocations() {
        this.location_projectionMatrix = super.getUniformLocation("projectionMatrix");
        this.location_viewMatrix = super.getUniformLocation("viewMatrix");
        this.location_transformationMatrix = super.getUniformLocation("transformationMatrix");
    }

    public void loadProjectionMatrix(Matrix4f matrix) {
        super.loadMatrix(this.location_projectionMatrix, matrix);
    }

    public void loadViewMatrix(Camera camera) {
        super.loadMatrix(this.location_viewMatrix, Maths.createViewMatrix(camera));
    }

    public void loadTransformationMatrix(Matrix4f matrix) {
        super.loadMatrix(this.location_transformationMatrix, matrix);
    }
}

