/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.shaders;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import theGhastModding.weightDisplay.shaders.ShaderException;

public abstract class ShaderProgram {
    private int programID;
    private int vertexShaderID;
    private int fragmentShaderID;
    private FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer(16);

    public ShaderProgram(String vertexFile, String fragmentFile) throws Exception {
        this.vertexShaderID = ShaderProgram.loadShader(vertexFile, 35633);
        this.fragmentShaderID = ShaderProgram.loadShader(fragmentFile, 35632);
        this.programID = GL20.glCreateProgram();
        GL20.glAttachShader(this.programID, this.vertexShaderID);
        GL20.glAttachShader(this.programID, this.fragmentShaderID);
        this.bindAttributes();
        GL20.glLinkProgram(this.programID);
        GL20.glValidateProgram(this.programID);
        this.getAllUniformLocations();
    }

    protected abstract void bindAttributes();

    protected void bindAttribute(int attribute, String variableName) {
        GL20.glBindAttribLocation(this.programID, attribute, variableName);
    }

    protected abstract void getAllUniformLocations();

    protected int getUniformLocation(String uniformName) {
        return GL20.glGetUniformLocation(this.programID, uniformName);
    }

    protected int getUniformBlockIndex(String blockName) {
        return GL31.glGetUniformBlockIndex(this.programID, blockName);
    }

    protected void loadDataToBlock(int blockLocation, FloatBuffer data, int offset) {
        int bindingPoint = 1;
        int buffer = GL15.glGenBuffers();
        GL15.glBindBuffer(35345, buffer);
        GL15.glBufferSubData(35345, (long)offset, data);
        GL31.glUniformBlockBinding(this.programID, blockLocation, bindingPoint);
        GL30.glBindBufferBase(35345, bindingPoint, buffer);
        GL15.glBindBuffer(35345, 0);
    }

    protected void loadDataToBlock(int blockLocation, FloatBuffer data) {
        int bindingPoint = 1;
        int buffer = GL15.glGenBuffers();
        GL15.glBindBuffer(35345, buffer);
        GL15.glBufferData(35345, data, 35044);
        GL31.glUniformBlockBinding(this.programID, blockLocation, bindingPoint);
        GL30.glBindBufferBase(35345, bindingPoint, buffer);
        GL15.glBindBuffer(35345, 0);
    }

    public void start() {
        GL20.glUseProgram(this.programID);
    }

    public void stop() {
        GL20.glUseProgram(0);
    }

    public void cleanUp() {
        this.stop();
        GL20.glDetachShader(this.programID, this.vertexShaderID);
        GL20.glDetachShader(this.programID, this.fragmentShaderID);
        GL20.glDeleteProgram(this.vertexShaderID);
        GL20.glDeleteProgram(this.fragmentShaderID);
        GL20.glDeleteProgram(this.programID);
    }

    private static int loadShader(String file, int type) throws Exception {
        String shader = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(ShaderProgram.class.getResourceAsStream(file)));
        String currLine = "lol";
        while (currLine != null) {
            currLine = reader.readLine();
            if (currLine == null) continue;
            shader = String.valueOf(shader) + currLine + "\n";
        }
        shader = shader.substring(0, shader.length() - 1);
        reader.close();
        int shaderID = GL20.glCreateShader(type);
        GL20.glShaderSource(shaderID, (CharSequence)shader);
        GL20.glCompileShader(shaderID);
        if (GL20.glGetShaderi(shaderID, 35713) == 0) {
            System.out.println(GL20.glGetShaderInfoLog(shaderID));
            throw new ShaderException(type, shaderID, "Could not compile " + (type == 35633 ? "vertex" : "fragment") + " shader.");
        }
        return shaderID;
    }

    protected void loadFloat(int location, float value) {
        GL20.glUniform1f(location, value);
    }

    protected void loadVector(int location, Vector3f vector) {
        GL20.glUniform3f(location, vector.x, vector.y, vector.z);
    }

    public void loadVector(int location, Vector2f vector) {
        GL20.glUniform2f(location, vector.x, vector.y);
    }

    protected void loadInt(int location, int value) {
        GL20.glUniform1i(location, value);
    }

    protected void loadBoolean(int location, boolean b) {
        if (b) {
            this.loadFloat(location, 1.0f);
        } else {
            this.loadFloat(location, 0.0f);
        }
    }

    protected void loadMatrix(int location, Matrix4f matrix) {
        GL20.glUniformMatrix4fv(location, false, matrix.get(this.matrixBuffer));
    }
}

