/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.renderer;

import java.awt.Dimension;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import theGhastModding.weightDisplay.main.WeightDisplay;
import theGhastModding.weightDisplay.renderer.WeightMesh;
import theGhastModding.weightDisplay.renderer.WeightsMesher;
import theGhastModding.weightDisplay.resources.Camera;
import theGhastModding.weightDisplay.shaders.WeightShader;
import theGhastModding.weightDisplay.utils.Maths;

public class BlocksRenderer {
    private WeightShader shader = new WeightShader();
    private static final float FOV = 70.0f;
    private static final float NEAR_PLANE = 0.1f;
    private static final float FAR_PLANE = 1024.0f;
    private Matrix4f projectionMatrix;
    private static final float RED = 0.1f;
    private static final float GREEN = 0.578125f;
    private static final float BLUE = 1.0f;

    public BlocksRenderer(long window) throws Exception {
        BlocksRenderer.enableCulling();
        this.createProjectionMatrix(window);
        this.shader.start();
        this.shader.loadProjectionMatrix(this.projectionMatrix);
        this.shader.stop();
    }

    public static void enableCulling() {
        GL11.glEnable(2884);
        GL11.glCullFace(1029);
    }

    public static void disableCulling() {
        GL11.glDisable(2884);
    }

    public void render(Camera camera, WeightsMesher[] meshers) throws Exception {
        this.prepare();
        BlocksRenderer.enableCulling();
        this.shader.start();
        this.shader.loadViewMatrix(camera);
        GL13.glActiveTexture(33984);
        int i = 0;
        while (i < meshers.length) {
            WeightMesh mesh = meshers[i].getMesh();
            if (!mesh.isEmpty() && !((double)mesh.getWeightMatrix().getScale() <= 0.0)) {
                this.shader.loadTransformationMatrix(Maths.createTransformationMatrix(mesh.getWeightMatrix().getPos(), new Vector3f(0.0f, 0.0f, 0.0f), mesh.getWeightMatrix().getScale()));
                GL30.glBindVertexArray(mesh.getModel().getId());
                GL20.glEnableVertexAttribArray(0);
                GL20.glEnableVertexAttribArray(1);
                GL11.glDrawElements(4, mesh.getModel().getVertexCount(), 5125, 0L);
            }
            ++i;
        }
        GL20.glDisableVertexAttribArray(0);
        GL20.glDisableVertexAttribArray(1);
        GL30.glBindVertexArray(0);
        this.shader.stop();
    }

    private void prepare() throws Exception {
        GL11.glEnable(2929);
        GL11.glClearColor(0.1f, 0.578125f, 1.0f, 1.0f);
        GL11.glClear(16640);
    }

    public void cleanUp() {
        this.shader.cleanUp();
    }

    private void createProjectionMatrix(long window) {
        Dimension screenSize = WeightDisplay.getWindowSize(window);
        float aspectRatio = (float)screenSize.width / (float)screenSize.height;
        float y_scale = (float)(1.0 / Math.tan(Math.toRadians(35.0)) * (double)aspectRatio);
        float x_scale = y_scale / aspectRatio;
        float frustum_length = 1023.9f;
        this.projectionMatrix = new Matrix4f();
        this.projectionMatrix.m00(x_scale);
        this.projectionMatrix.m11(y_scale);
        this.projectionMatrix.m22(-(1024.1f / frustum_length));
        this.projectionMatrix.m23(-1.0f);
        this.projectionMatrix.m32(-(204.8f / frustum_length));
        this.projectionMatrix.m33(0.0f);
    }
}

