/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.weightDisplay.main;

import java.awt.Dimension;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import theGhastModding.weightDisplay.main.WeightMatrix;
import theGhastModding.weightDisplay.renderer.BlocksRenderer;
import theGhastModding.weightDisplay.renderer.WeightsMesher;
import theGhastModding.weightDisplay.resources.Camera;
import theGhastModding.weightDisplay.resources.Loader;

public class WeightDisplay
implements Runnable {
    private long window = Long.MAX_VALUE;
    private Thread renderThread;
    private boolean shouldRender = true;
    private String title;
    public float delta = 1.0f;
    public boolean cursorGrabbed = false;
    private boolean initialized = false;
    private WeightMatrix[] weights;
    private WeightsMesher[] meshers;
    private boolean[] dirty;
    private int width;
    private int height;
    private int depth;

    public WeightDisplay(String title, int width, int height, int depth) throws Exception {
        if (!GLFW.glfwInit()) {
            throw new Exception("Error initializing GLFW!");
        }
        this.title = title;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.renderThread = new Thread(this);
    }

    public void open() {
        this.shouldRender = true;
        this.initialized = false;
        this.renderThread.start();
        while (!this.initialized) {
            try {
                Thread.sleep(128L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.shouldRender = false;
    }

    private void createWindow() throws Exception {
        GLFW.glfwWindowHint(135181, 16);
        this.window = GLFW.glfwCreateWindow(427, 320, this.title, 0L, 0L);
        GLFW.glfwHideWindow(this.window);
        if (this.window == 0L) {
            throw new Exception("Error creating window!");
        }
        GLFWVidMode videoMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        GLFW.glfwSetWindowPos(this.window, (videoMode.width() - 1280) / 2, (videoMode.height() - 720) / 2);
        GLFW.glfwShowWindow(this.window);
    }

    @Override
    public void run() {
        try {
            this.createWindow();
            GLFW.glfwMakeContextCurrent(this.window);
            GL.createCapabilities();
            GL11.glEnable(32925);
            Loader loader = new Loader();
            this.weights = new WeightMatrix[this.depth];
            this.meshers = new WeightsMesher[this.depth];
            this.dirty = new boolean[this.depth];
            int faceCount = 0;
            float distance = Math.min(16.0f, Math.max(5.0f, 128.0f / (float)this.depth));
            int i = 0;
            while (i < this.depth) {
                this.weights[i] = new WeightMatrix(this.width, this.height, (float)(-i) * distance, distance);
                this.meshers[i] = new WeightsMesher(this.weights[i]);
                this.meshers[i].meshChunk(loader);
                this.dirty[i] = false;
                faceCount += this.meshers[i].getLastFaceCount();
                ++i;
            }
            System.out.println(String.valueOf(Integer.toString(faceCount)) + " total faces");
            BlocksRenderer renderer = new BlocksRenderer(this.window);
            Camera cam = new Camera(this.window, this);
            this.initialized = true;
            int frameCntr = 0;
            long debugTimer = System.currentTimeMillis();
            long frameTimer = System.nanoTime();
            long triggerDelay = System.currentTimeMillis();
            long frameTime = 15625000L;
            int selectPos = 0;
            boolean holdingShift = false;
            while (this.shouldRender) {
                this.delta = (float)(System.nanoTime() - frameTimer) / 1000.0f;
                cam.update();
                GLFW.glfwPollEvents();
                int i2 = 0;
                while (i2 < this.depth) {
                    if (this.dirty[i2]) {
                        this.meshers[i2].meshChunk(loader);
                        this.dirty[i2] = false;
                    }
                    this.weights[i2].updateAnimation();
                    ++i2;
                }
                renderer.render(cam, this.meshers);
                GLFW.glfwSwapBuffers(this.window);
                ++frameCntr;
                frameTimer = System.nanoTime();
                if (GLFW.glfwGetKey(this.window, 297) == 1 && System.currentTimeMillis() - triggerDelay >= 200L) {
                    if (this.cursorGrabbed) {
                        GLFW.glfwSetInputMode(this.window, 208897, 212993);
                        this.cursorGrabbed = false;
                    } else {
                        GLFW.glfwSetInputMode(this.window, 208897, 212995);
                        this.cursorGrabbed = true;
                    }
                    triggerDelay = System.currentTimeMillis();
                }
                if (GLFW.glfwGetKey(this.window, 298) == 1 && System.currentTimeMillis() - triggerDelay >= 200L) {
                    i2 = 0;
                    while (i2 < this.depth) {
                        this.meshers[i2].setUseRelativeBrightness(!this.meshers[i2].isUsingRelativeBrightness());
                        this.meshers[i2].meshChunk(loader);
                        ++i2;
                    }
                    triggerDelay = System.currentTimeMillis();
                }
                holdingShift = GLFW.glfwGetKey(this.window, 340) == 1 || GLFW.glfwGetKey(this.window, 344) == 1;
                if (GLFW.glfwGetKey(this.window, 78) == 1 && System.currentTimeMillis() - triggerDelay >= 200L && !this.anyInAnimation() && selectPos < this.weights.length - 1) {
                    if (holdingShift && selectPos < this.weights.length - 2) {
                        this.weights[selectPos].setAnimation(0, 2);
                        this.weights[selectPos + 1].setAnimation(0, 2);
                        selectPos += 2;
                        i2 = this.weights.length - 1;
                        while (i2 >= selectPos) {
                            this.weights[i2].setAnimation(2, 2);
                            --i2;
                        }
                    } else {
                        this.weights[selectPos].setAnimation(0, 1);
                        ++selectPos;
                        i2 = this.weights.length - 1;
                        while (i2 >= selectPos) {
                            this.weights[i2].setAnimation(2, 1);
                            --i2;
                        }
                    }
                    triggerDelay = System.currentTimeMillis();
                }
                if (GLFW.glfwGetKey(this.window, 80) == 1 && System.currentTimeMillis() - triggerDelay >= 200L && !this.anyInAnimation() && selectPos > 0) {
                    if (holdingShift && selectPos > 1) {
                        this.weights[selectPos - 1].setAnimation(1, 2);
                        this.weights[selectPos - 2].setAnimation(1, 2);
                        i2 = this.weights.length - 1;
                        while (i2 >= selectPos) {
                            this.weights[i2].setAnimation(3, 2);
                            --i2;
                        }
                        selectPos -= 2;
                    } else {
                        this.weights[selectPos - 1].setAnimation(1, 1);
                        i2 = this.weights.length - 1;
                        while (i2 >= selectPos) {
                            this.weights[i2].setAnimation(3, 1);
                            --i2;
                        }
                        --selectPos;
                    }
                    triggerDelay = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - debugTimer >= 1000L) {
                    long diff = System.currentTimeMillis() - debugTimer;
                    double fps = (double)frameCntr * ((double)diff / 1000.0);
                    GLFW.glfwSetWindowTitle(this.window, String.valueOf(this.title) + " - " + String.format("%.4f", fps) + "FPS");
                    frameCntr = 0;
                    debugTimer = System.currentTimeMillis();
                }
                Thread.sleep(Math.max(0L, (long)((double)(15625000L - (System.nanoTime() - frameTimer)) / 1000000.0)));
            }
            try {
                GLFW.glfwHideWindow(this.window);
                GLFW.glfwDestroyWindow(this.window);
                this.window = Long.MAX_VALUE;
                loader.cleanUp();
                renderer.cleanUp();
                this.weights = null;
                this.meshers = null;
                this.dirty = null;
                System.gc();
            }
            catch (Exception e) {
                System.err.println("Error disposing frame!");
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.initialized = true;
            System.err.println("Error rendering!");
            e.printStackTrace();
            this.dispose();
        }
    }

    private boolean anyInAnimation() {
        WeightMatrix[] weightMatrixArray = this.weights;
        int n = this.weights.length;
        int n2 = 0;
        while (n2 < n) {
            WeightMatrix wm = weightMatrixArray[n2];
            if (wm.isInAnimation()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setPos(int xpos, int ypos) {
        if (this.window == Long.MAX_VALUE) {
            return;
        }
        GLFW.glfwSetWindowPos(this.window, xpos, ypos);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public WeightMatrix getMatrix(int depth) {
        if (this.weights == null) {
            return null;
        }
        return this.weights[depth];
    }

    public void notifyChange(int depth) {
        if (this.dirty == null) {
            return;
        }
        this.dirty[depth] = true;
    }

    public static Dimension getWindowSize(long window) {
        IntBuffer w = BufferUtils.createIntBuffer(1);
        IntBuffer h = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetWindowSize(window, w, h);
        return new Dimension(w.get(0), h.get(0));
    }
}

