/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.main;

import autodiff.GPUGraph;
import autodiff.MultiGPUGraph;
import java.util.Random;
import java.util.UUID;
import matrix.Matrix;
import matrix.Tensor;
import model.ConvLayer;
import nonlinearities.LinearUnit;
import util.CLUtils;

public class GPUTestNonlins {
    public static void main(String[] args) {
        try {
            int j;
            Random rng = new Random();
            double perf = 0.53;
            MultiGPUGraph gg = CLUtils.createGraph(CLUtils.findDevice("AMD", "Tahiti")[0], 1.0 - perf, CLUtils.findDevice("AMD", "Ellesmere")[0], perf, false);
            UUID uuid2 = UUID.randomUUID();
            ((GPUGraph)gg).forceKeepParameters(true);
            Tensor in = Tensor.rand(64, 64, 128, 0.1, rng);
            Matrix[] filters = new Matrix[16384];
            int i = 0;
            while (i < filters.length) {
                filters[i] = Matrix.rand(4, 4, 0.1, rng);
                ++i;
            }
            Matrix[] filtersClone = new Matrix[16384];
            int i2 = 0;
            while (i2 < filters.length) {
                filtersClone[i2] = filters[i2].clone();
                ++i2;
            }
            Matrix bias = Matrix.uniform(128, 1, 0.0);
            ConvLayer cl = new ConvLayer(64, 64, 128, 4, 4, 128, 1, 1, new LinearUnit(), 0.1, rng, true, true, 8);
            long startTimee = System.currentTimeMillis();
            int cntr = 0;
            int secCntr = 0;
            double[] dws = new double[in.width * in.height];
            int i3 = 0;
            while (i3 < dws.length) {
                dws[i3] = rng.nextGaussian() * 0.1;
                ++i3;
            }
            System.err.println("20");
            while (System.currentTimeMillis() - startTimee <= 20480L) {
                cl.forward(in, gg);
                ++cntr;
                if ((System.currentTimeMillis() - startTimee) / 1000L <= (long)secCntr) continue;
                System.err.println(Integer.toString(20 - ++secCntr));
            }
            double res = 20480.0 / (double)(System.currentTimeMillis() - startTimee) * (double)cntr;
            System.err.println(Double.toString(res));
            ((GPUGraph)gg).cleanUp();
            System.exit(0);
            LinearUnit lin = new LinearUnit();
            Tensor in2 = in.clone();
            Tensor res1 = ((GPUGraph)gg).fullConv(true, 1, 2, 128, in, bias, filters, lin, uuid2);
            Tensor res2 = gg.convolution(1, 2, 128, in2, filtersClone);
            int i4 = 0;
            while (i4 < res1.depth) {
                Matrix m1 = res1.matrices[i4];
                Matrix m2 = res2.matrices[i4];
                j = 0;
                while (j < m1.dw.length) {
                    m1.dw[j] = m2.dw[j] = rng.nextGaussian() * 0.1;
                    ++j;
                }
                ++i4;
            }
            ((GPUGraph)gg).backward();
            Matrix m1 = in.matrices[12];
            Matrix m2 = in2.matrices[12];
            int i5 = 0;
            while (i5 < m1.rows) {
                j = 0;
                while (j < m1.cols) {
                    double d2;
                    double d1 = m1.getDW(i5, j);
                    if (Math.abs(d1 - (d2 = m2.getDW(i5, j))) > 0.001) {
                        System.err.print("\t" + String.format("%.4f", d1));
                        Thread.sleep(800L);
                    } else {
                        System.out.print("\t" + String.format("%.4f", d1));
                    }
                    ++j;
                }
                System.out.println();
                ++i5;
            }
            Thread.sleep(128L);
            long timer2 = 0L;
            int i6 = 0;
            while (i6 < 32) {
                System.err.println(i6);
                long startTime = System.nanoTime();
                res1 = ((GPUGraph)gg).fullConv(true, 0, 1, 128, in, bias, filters, lin, uuid2);
                timer2 += System.nanoTime() - startTime;
                int i22 = 0;
                while (i22 < res1.depth) {
                    m1 = res1.matrices[i22];
                    m2 = res2.matrices[i22];
                    System.arraycopy(m2.dw, 0, m1.dw, 0, m2.dw.length);
                    ++i22;
                }
                ((GPUGraph)gg).backward();
                ++i6;
            }
            ((GPUGraph)gg).forceKeepParameters(false);
            ((GPUGraph)gg).cleanUp();
            System.out.println(timer2 / 1000L / 1000L);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

