/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.gameThingy;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;

public class Touhou10Wrapper {
    static Kernel32 kernel32 = Native.loadLibrary("kernel32", Kernel32.class);
    static User32 user32 = Native.loadLibrary("user32", User32.class);
    public static int PROCESS_VM_READ = 16;
    public static int PROCESS_VM_WRITE = 32;
    public static Pointer SCORE_ADDR = new Pointer(0x474C44L);
    public static Rectangle innerGameWindow = new Rectangle(35, 42, 384, 448);
    public static Rectangle livesWindows = new Rectangle(518, 133, 110, 14);
    private File executable;
    private Robot robot;
    private IntByReference pid;
    private WinNT.HANDLE process;
    private Memory scoreBuffer = new Memory(4L);

    public Touhou10Wrapper(File gameExecutable) {
        this.executable = gameExecutable;
    }

    public void start() throws Exception {
        Desktop.getDesktop().open(this.executable);
        Thread.sleep(8000L);
        this.pid = new IntByReference(0);
        WinDef.HWND window = User32.INSTANCE.FindWindow(null, "Touhou Fuujinroku - Mountain of Faith v1.00a");
        user32.GetWindowThreadProcessId(window, this.pid);
        this.process = kernel32.OpenProcess(PROCESS_VM_READ | PROCESS_VM_WRITE, true, this.pid.getValue());
        user32.MoveWindow(window, 0, 0, 646, 509, true);
        user32.SetFocus(window);
        this.robot = new Robot();
        System.out.println("[DEBUG] Process ID of game is " + Integer.toString(this.pid.getValue()));
        this.reset();
    }

    public void reset() throws Exception {
        this.scoreBuffer.setInt(0L, Integer.MAX_VALUE);
        kernel32.WriteProcessMemory(this.process, SCORE_ADDR, this.scoreBuffer, PROCESS_VM_WRITE, null);
    }

    public void stop() throws Exception {
        kernel32.CloseHandle(this.process);
    }

    public int getExtraLives() {
        int lives = 0;
        BufferedImage screen = this.robot.createScreenCapture(livesWindows);
        int i = 0;
        while (i < 9) {
            if ((screen.getRGB(7 + 12 * i, 7) >> 16 & 0xFF) > 125) {
                ++lives;
            }
            ++i;
        }
        return lives;
    }

    public int getScore() throws Exception {
        kernel32.ReadProcessMemory(this.process, SCORE_ADDR, this.scoreBuffer, 4, this.pid);
        return this.scoreBuffer.getInt(0L);
    }

    public boolean isInStage() {
        return true;
    }

    public BufferedImage getGameScreen() {
        return this.robot.createScreenCapture(innerGameWindow);
    }

    public File getGameExecutable() {
        return this.executable;
    }
}

